/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.filters;

import edu.cornell.mannlib.vitro.webapp.filters.VitroURL;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class VitroURLTest {
    @Test
    public void testBeginsWithSlash() {
        String pathStr = "entity?home=1&uri=http://aims.fao.org/aos/geopolitical.owl#Afghanistan";
        VitroURL instance = new VitroURL("", "UTF-8");
        boolean expResult = false;
        boolean result = instance.beginsWithSlash(pathStr);
        Assert.assertEquals((Object)expResult, (Object)result);
    }

    @Test
    public void testEndsInSlash() {
        String pathStr = "/entity?home=1&uri=http://aims.fao.org/aos/geopolitical.owl#Afghanistan";
        VitroURL instance = new VitroURL("", "UTF-8");
        boolean expResult = false;
        boolean result = instance.endsInSlash(pathStr);
        Assert.assertEquals((Object)expResult, (Object)result);
    }

    @Test
    public void testToString() {
        String MelbUniStr = "/entity?home=1&uri=HTTPS://bida.themis.unimelb.edu.au/pls/apex/f?p=mrw2rdf:org:::::org_id:145";
        VitroURL instance = new VitroURL(MelbUniStr, "UTF-8");
        String expResult = "/entity?home=1&uri=HTTPS%3A%2F%2Fbida.themis.unimelb.edu.au%2Fpls%2Fapex%2Ff%3Fp%3Dmrw2rdf%3Aorg%3A%3A%3A%3A%3Aorg_id%3A145";
        String result = instance.toString();
        Assert.assertEquals((Object)expResult, (Object)result);
        String defaultTestStr = "/entity?home=1&uri=http://aims.fao.org/aos/geopolitical.owl#Afghanistan";
        instance = new VitroURL(defaultTestStr, "UTF-8");
        expResult = "/entity?home=1&uri=http%3A%2F%2Faims.fao.org%2Faos%2Fgeopolitical.owl%23Afghanistan";
        result = instance.toString();
        Assert.assertEquals((Object)expResult, (Object)result);
    }

    @Test
    public void testWithEqualsSign() {
        String MelbUniStr = "/entity?home=1&uri=HTTPS://bida.themis.unimelb.edu.au/pls/apex/f?p=mrw2rdf:org:::::org_id:145";
        VitroURL instance = new VitroURL(MelbUniStr, "UTF-8");
        String expResult = "/entity?home=1&uri=HTTPS%3A%2F%2Fbida.themis.unimelb.edu.au%2Fpls%2Fapex%2Ff%3Fp%3Dmrw2rdf%3Aorg%3A%3A%3A%3A%3Aorg_id%3A145";
        Assert.assertEquals((Object)expResult, (Object)instance.toString());
    }

    @Test
    public void testParseQueryParams() {
        VitroURL instance = new VitroURL("stringNotImportant", "UTF-8");
        List result = instance.parseQueryParams("uri=HTTPS://bida.themis.unimelb.edu.au/pls/apex/f?p=mrw2rdf:org:::::org_id:145");
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertNotNull(result.get(0));
        Assert.assertEquals((long)2L, (long)((String[])result.get(0)).length);
        Assert.assertEquals((Object)"uri", (Object)((String[])result.get(0))[0]);
        Assert.assertEquals((Object)"HTTPS://bida.themis.unimelb.edu.au/pls/apex/f?p=mrw2rdf:org:::::org_id:145", (Object)((String[])result.get(0))[1]);
    }

    @Test
    public void testParseQueryParams2() {
        VitroURL instance = new VitroURL("stringNotImportant", "UTF-8");
        List result = instance.parseQueryParams("home=1&uri=HTTPS://bida.themis.unimelb.edu.au/pls/apex/f?p=mrw2rdf:org:::::org_id:145");
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertNotNull(result.get(0));
        Assert.assertEquals((long)2L, (long)((String[])result.get(0)).length);
        Assert.assertEquals((Object)"home", (Object)((String[])result.get(0))[0]);
        Assert.assertEquals((Object)"1", (Object)((String[])result.get(0))[1]);
        Assert.assertNotNull(result.get(1));
        Assert.assertEquals((long)2L, (long)((String[])result.get(1)).length);
        Assert.assertEquals((Object)"uri", (Object)((String[])result.get(1))[0]);
        Assert.assertEquals((Object)"HTTPS://bida.themis.unimelb.edu.au/pls/apex/f?p=mrw2rdf:org:::::org_id:145", (Object)((String[])result.get(1))[1]);
    }

    @Test
    public void testParseQueryParams3() {
        VitroURL instance = new VitroURL("stringNotImportant", "UTF-8");
        List result = instance.parseQueryParams("home=1&uri=HTTPS://bida.edu.au/pls/apex/f?p=mrw2&additiona=234");
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertNotNull(result.get(0));
        Assert.assertEquals((long)2L, (long)((String[])result.get(0)).length);
        Assert.assertEquals((Object)"home", (Object)((String[])result.get(0))[0]);
        Assert.assertEquals((Object)"1", (Object)((String[])result.get(0))[1]);
        Assert.assertNotNull(result.get(1));
        Assert.assertEquals((long)2L, (long)((String[])result.get(1)).length);
        Assert.assertEquals((Object)"uri", (Object)((String[])result.get(1))[0]);
        Assert.assertEquals((Object)"HTTPS://bida.edu.au/pls/apex/f?p=mrw2&additiona=234", (Object)((String[])result.get(1))[1]);
    }

    @Test(expected=Error.class)
    public void testParseQueryParams4() {
        VitroURL instance = new VitroURL("stringNotImportant", "UTF-8");
        List result = instance.parseQueryParams("home=1&shouldBeURI=HTTPS://bida.edu.au/pls/apex/f?p=mrw2&additiona=234");
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertNotNull(result.get(0));
        Assert.assertEquals((long)2L, (long)((String[])result.get(0)).length);
        Assert.assertEquals((Object)"home", (Object)((String[])result.get(0))[0]);
        Assert.assertEquals((Object)"1", (Object)((String[])result.get(0))[1]);
        Assert.assertNotNull(result.get(1));
        Assert.assertEquals((long)2L, (long)((String[])result.get(1)).length);
        Assert.assertEquals((Object)"uri", (Object)((String[])result.get(1))[0]);
        Assert.assertEquals((Object)"HTTPS://bida.edu.au/pls/apex/f?p=mrw2&additiona=234", (Object)((String[])result.get(1))[1]);
    }
}

