/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.imageprocessor.jai;

import com.sun.media.jai.codec.MemoryCacheSeekableStream;
import com.sun.media.jai.codec.SeekableStream;
import edu.cornell.mannlib.vitro.webapp.imageprocessor.jai.JaiImageProcessor;
import edu.cornell.mannlib.vitro.webapp.modules.imageProcessor.ImageProcessor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.StreamDescriptor;
import javax.media.jai.util.ImagingListener;
import javax.media.jai.widget.ImageCanvas;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public class JaiImageProcessorTester2
extends Frame {
    private static final Log log = LogFactory.getLog(JaiImageProcessorTester2.class);
    private static final int ROWS = 6;
    private static final int COLUMNS = 9;
    private static final int EDGE_THRESHOLD = 6000;
    private static final ImageProcessor.Dimensions THUMBNAIL_SIZE = new ImageProcessor.Dimensions(200, 200);
    private final String imagePath;
    private final JaiImageProcessor thumbnailer;

    public JaiImageProcessorTester2(String imagePath, CropDataSet cropDataSet) {
        this.imagePath = imagePath;
        this.thumbnailer = new JaiImageProcessor();
        this.setTitle("Cropping edging test");
        this.addWindowListener(new CloseWindowListener());
        this.setLayout(new GridLayout(6, 9));
        for (CropDataSet.CropData cropData : cropDataSet.crops()) {
            this.add(this.createImagePanel(cropData));
        }
        this.pack();
        this.setVisible(true);
    }

    private Component createImagePanel(CropDataSet.CropData cropData) {
        RenderedOp image = this.createCroppedImage(cropData);
        Set<String> blackSides = this.checkBlackEdges(image);
        if (!blackSides.isEmpty()) {
            log.warn((Object)("edges  at " + cropData + ", " + blackSides));
        }
        String legend = "left=" + cropData.left + ", top=" + cropData.top + ", size=" + cropData.size;
        Label l = new Label();
        l.setAlignment(1);
        if (!blackSides.isEmpty()) {
            l.setBackground(new Color(0xFFDDDD));
            legend = legend + " " + blackSides;
        }
        l.setText(legend);
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        p.add("South", l);
        p.add("Center", (Component)new ImageCanvas((RenderedImage)image));
        p.setBackground(new Color(0xFFFFFF));
        p.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        return p;
    }

    private RenderedOp createCroppedImage(CropDataSet.CropData cropData) {
        try {
            FileInputStream mainStream = new FileInputStream(this.imagePath);
            ImageProcessor.CropRectangle rectangle = new ImageProcessor.CropRectangle(cropData.left, cropData.top, cropData.size, cropData.size);
            InputStream thumbnailStream = this.thumbnailer.cropAndScale((InputStream)mainStream, rectangle, THUMBNAIL_SIZE);
            return StreamDescriptor.create((SeekableStream)new MemoryCacheSeekableStream(thumbnailStream), null, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Set<String> checkBlackEdges(RenderedOp image) {
        Raster imageData = image.getData();
        int minX = imageData.getMinX();
        int minY = imageData.getMinY();
        int maxX = minX + imageData.getWidth() - 1;
        int maxY = minY + imageData.getHeight() - 1;
        HashSet<String> blackSides = new HashSet<String>();
        if (this.isBlackEdge(minX, minX, minY, maxY, imageData)) {
            blackSides.add("left");
        }
        if (this.isBlackEdge(minX, maxX, minY, minY, imageData)) {
            blackSides.add("top");
        }
        if (this.isBlackEdge(maxX, maxX, minY, maxY, imageData)) {
            blackSides.add("right");
        }
        if (this.isBlackEdge(minX, maxX, maxY, maxY, imageData)) {
            blackSides.add("bottom");
        }
        return blackSides;
    }

    private boolean isBlackEdge(int fromX, int toX, int fromY, int toY, Raster imageData) {
        int edgeTotal = 0;
        try {
            for (int col = fromX; col <= toX; ++col) {
                for (int row = fromY; row <= toY; ++row) {
                    edgeTotal += this.sumPixel(imageData, col, row);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("can't sum edge: fromX=" + fromX + ", toX=" + toX + ", fromY=" + fromY + ", toY=" + toY + ", imageWidth=" + imageData.getWidth() + ", imageHeight=" + imageData.getHeight() + ": " + e));
        }
        log.debug((Object)("edge total = " + edgeTotal));
        return edgeTotal < 6000;
    }

    private int sumPixel(Raster imageData, int col, int row) {
        int[] pixel;
        int pixelSum = 0;
        for (int value : pixel = imageData.getPixel(col, row, new int[0])) {
            pixelSum += value;
        }
        return pixelSum;
    }

    public static void main(String[] args) {
        Logger rootLogger = Logger.getRootLogger();
        Appender appender = (Appender)rootLogger.getAllAppenders().nextElement();
        appender.setLayout((Layout)new PatternLayout("%-5p [%c{1}] %m%n"));
        Logger.getLogger(JaiImageProcessor.class).setLevel(Level.DEBUG);
        Logger.getLogger(JaiImageProcessorTester2.class).setLevel(Level.INFO);
        CropDataSet cropDataSet = new CropDataSet();
        for (int i = 0; i < 54; ++i) {
            cropDataSet.add(0, 0, 201 + i);
        }
        new JaiImageProcessorTester2("C:/Users/jeb228/Pictures/wheel.png", cropDataSet);
    }

    static {
        JAI.getDefaultInstance().setImagingListener((ImagingListener)new JaiImageProcessor.NonNoisyImagingListener());
    }

    public static class CropDataSet {
        private final List<CropData> crops = new ArrayList<CropData>();

        CropDataSet add(int left, int top, int size) {
            this.crops.add(new CropData(left, top, size));
            return this;
        }

        Collection<CropData> crops() {
            return Collections.unmodifiableCollection(this.crops);
        }

        public static class CropData {
            final int left;
            final int top;
            final int size;

            CropData(int left, int top, int size) {
                this.left = left;
                this.top = top;
                this.size = size;
            }

            public String toString() {
                return "CropData[" + this.left + ", " + this.top + ", " + this.size + "]";
            }
        }
    }

    private class CloseWindowListener
    extends WindowAdapter {
        private CloseWindowListener() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            JaiImageProcessorTester2.this.setVisible(false);
            JaiImageProcessorTester2.this.dispose();
            System.exit(0);
        }
    }
}

