/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.modelaccess.adapters;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.impl.CollectionGraph;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.ModelMaker;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import edu.cornell.mannlib.vitro.webapp.modelaccess.adapters.MemoryMappingModelMaker;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import stubs.com.hp.hpl.jena.rdf.model.ModelMaker.ModelMakerStub;

public class MemoryMappingModelMakerTest
extends AbstractTestClass {
    private static final String URI_MAPPED = "http://memory.mapped.model";
    private static final String URI_UNMAPPED = "http://unmapped.model";
    private static final String MODEL_CONTENTS = "@prefix : <http://z#> . \n:a :b :c .";
    private GraphModelStructure unmapped;
    private GraphModelStructure mapped;
    private ModelMakerStub innerModelMaker;
    private MemoryMappingModelMaker mmmm;

    @Before
    public void setup() {
        this.unmapped = new GraphModelStructure(URI_UNMAPPED, MODEL_CONTENTS);
        this.mapped = new GraphModelStructure(URI_MAPPED, MODEL_CONTENTS);
        this.innerModelMaker = ModelMakerStub.rigorous(MemoryMappingModelMakerTest.createModel(), MemoryMappingModelMakerTest.createModel());
        this.innerModelMaker.put(this.mapped.uri, this.mapped.model);
        this.innerModelMaker.put(this.unmapped.uri, this.unmapped.model);
        this.mmmm = new MemoryMappingModelMaker((ModelMaker)this.innerModelMaker, new String[]{this.mapped.uri});
        this.unmapped.methodCalls.clear();
        this.mapped.methodCalls.clear();
    }

    @Test
    public void unmappedRead() {
        this.assertModelContents(this.unmapped, "[http://z#a, http://z#b, http://z#c]");
        this.assertMethodCalls(this.unmapped, "find");
    }

    @Test
    public void mappedRead() {
        this.assertModelContents(this.mapped, "[http://z#a, http://z#b, http://z#c]");
        this.assertMethodCalls(this.mapped, new String[0]);
    }

    @Test
    public void unmappedWrite() {
        this.mmmm.openModel(URI_UNMAPPED).add(this.newStatement());
        this.assertModelContents(this.unmapped, "[http://z#a, http://z#b, http://z#c]", "[http://z#new, http://z#to, http://z#you]");
        this.assertMethodCalls(this.unmapped, "add", "find");
    }

    @Test
    public void mappedWrite() {
        this.mmmm.openModel(URI_MAPPED).add(this.newStatement());
        this.assertModelContents(this.mapped, "[http://z#a, http://z#b, http://z#c]", "[http://z#new, http://z#to, http://z#you]");
        this.assertMethodCalls(this.mapped, "add");
    }

    private static Model createModel() {
        return ModelFactory.createDefaultModel();
    }

    private void assertModelContents(GraphModelStructure gms, String ... expected) {
        Set stmts = this.mmmm.openModel(gms.uri).listStatements().toSet();
        this.assertStatements(stmts, expected);
    }

    private void assertStatements(Set<Statement> stmts, String ... expected) {
        HashSet<String> actual = new HashSet<String>();
        for (Statement stmt : stmts) {
            actual.add(stmt.toString());
        }
        Assert.assertEquals(new HashSet<String>(Arrays.asList(expected)), actual);
    }

    private void assertMethodCalls(GraphModelStructure gms, String ... expected) {
        Assert.assertEquals(Arrays.asList(expected), gms.methodCalls);
    }

    public Statement newStatement() {
        Resource s = ResourceFactory.createResource((String)"http://z#new");
        Property p = ResourceFactory.createProperty((String)"http://z#to");
        Resource o = ResourceFactory.createResource((String)"http://z#you");
        return ResourceFactory.createStatement((Resource)s, (Property)p, (RDFNode)o);
    }

    private static class RecordingInvocationHandler
    implements InvocationHandler {
        private final Object inner;
        private final List<String> methodCalls;

        public RecordingInvocationHandler(Object inner, List<String> methodCalls) {
            this.inner = inner;
            this.methodCalls = methodCalls;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            this.methodCalls.add(method.getName());
            return method.invoke(this.inner, args);
        }
    }

    private static class GraphModelStructure {
        final String uri;
        final Graph graph;
        final List<String> methodCalls;
        final RecordingInvocationHandler handler;
        final Graph proxy;
        final Model model;

        public GraphModelStructure(String uri, String contents) {
            this.uri = uri;
            this.graph = new CollectionGraph();
            this.methodCalls = new ArrayList<String>();
            this.handler = new RecordingInvocationHandler(this.graph, this.methodCalls);
            this.proxy = this.wrapGraph();
            this.model = ModelFactory.createModelForGraph((Graph)this.proxy);
            this.model.read((Reader)new StringReader(contents), null, "TURTLE");
        }

        private Graph wrapGraph() {
            ClassLoader classLoader = Model.class.getClassLoader();
            Class[] interfaces = new Class[]{Graph.class};
            return (Graph)Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)this.handler);
        }
    }
}

