/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils;

import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import edu.cornell.mannlib.vitro.webapp.utils.SparqlQueryRunner;
import org.junit.Assert;
import org.junit.Test;

public class SparqlQueryRunnerTest
extends AbstractTestClass {
    private static final String REAL_WORLD_RAW = "PREFIX : <http://vitro.mannlib.cornell.edu/ns/vitro/ApplicationConfiguration#> \n\nSELECT DISTINCT ?context ?config \nWHERE { \n    ?context a :ConfigContext ; \n        :configContextFor ?baseUri ; \n        :qualifiedByDomain ?domainUri ; \n        :qualifiedBy ?rangeUri ; \n        :hasConfiguration ?config . \n} \n";
    private static final String REAL_WORLD_EXPECTED = "PREFIX : <http://vitro.mannlib.cornell.edu/ns/vitro/ApplicationConfiguration#> \n\nSELECT DISTINCT ?context ?config \nWHERE { \n    ?context a :ConfigContext ; \n        :configContextFor <http://vivoweb.org/ontology/core#relates> ; \n        :qualifiedByDomain <http://vivoweb.org/ontology/core#Contract> ; \n        :qualifiedBy <http://vivoweb.org/ontology/core#ResearcherRole> ; \n        :hasConfiguration ?config . \n} \n";

    @Test
    public void bindValuesNameNotFound() {
        String raw;
        String expected = raw = "No such name here";
        Assert.assertEquals((Object)expected, (Object)SparqlQueryRunner.bindValues((String)raw, (SparqlQueryRunner.VariableValue[])new SparqlQueryRunner.VariableValue[]{SparqlQueryRunner.uriValue((String)"bogus", (String)"BOGUS")}));
    }

    @Test
    public void bindOneUri() {
        String raw = "Replace both ?this and ?this also.";
        String expected = "Replace both <URI> and <URI> also.";
        Assert.assertEquals((Object)expected, (Object)SparqlQueryRunner.bindValues((String)raw, (SparqlQueryRunner.VariableValue[])new SparqlQueryRunner.VariableValue[]{SparqlQueryRunner.uriValue((String)"this", (String)"URI")}));
    }

    @Test
    public void bindTwoUris() {
        String raw = "Replace both ?this and ?that also.";
        String expected = "Replace both <URI> and <ANOTHER> also.";
        Assert.assertEquals((Object)expected, (Object)SparqlQueryRunner.bindValues((String)raw, (SparqlQueryRunner.VariableValue[])new SparqlQueryRunner.VariableValue[]{SparqlQueryRunner.uriValue((String)"this", (String)"URI"), SparqlQueryRunner.uriValue((String)"that", (String)"ANOTHER")}));
    }

    @Test
    public void honorWordBoundary() {
        String raw = "Replace ?this but not ?thistle.";
        String expected = "Replace <URI> but not ?thistle.";
        Assert.assertEquals((Object)expected, (Object)SparqlQueryRunner.bindValues((String)raw, (SparqlQueryRunner.VariableValue[])new SparqlQueryRunner.VariableValue[]{SparqlQueryRunner.uriValue((String)"this", (String)"URI")}));
    }

    @Test
    public void honorStringLimit() {
        String raw = "?this";
        String expected = "<URI>";
        Assert.assertEquals((Object)expected, (Object)SparqlQueryRunner.bindValues((String)raw, (SparqlQueryRunner.VariableValue[])new SparqlQueryRunner.VariableValue[]{SparqlQueryRunner.uriValue((String)"this", (String)"URI")}));
    }

    @Test
    public void realWorldExample() {
        Assert.assertEquals((Object)REAL_WORLD_EXPECTED, (Object)SparqlQueryRunner.bindValues((String)REAL_WORLD_RAW, (SparqlQueryRunner.VariableValue[])new SparqlQueryRunner.VariableValue[]{SparqlQueryRunner.uriValue((String)"baseUri", (String)"http://vivoweb.org/ontology/core#relates"), SparqlQueryRunner.uriValue((String)"domainUri", (String)"http://vivoweb.org/ontology/core#Contract"), SparqlQueryRunner.uriValue((String)"rangeUri", (String)"http://vivoweb.org/ontology/core#ResearcherRole")}));
    }
}

