/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.configuration;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Statement;
import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import edu.cornell.mannlib.vitro.testing.ModelUtilitiesTestHelper;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ContextModelAccess;
import edu.cornell.mannlib.vitro.webapp.modelaccess.RequestModelAccess;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.ConfigurationBeanLoader;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.ConfigurationBeanLoaderException;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.ConfigurationRdfParser;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.ContextModelsUser;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.InstanceWrapper;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.Property;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.PropertyType;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.RequestModelsUser;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.Validation;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.WrappedInstance;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import stubs.edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccessFactoryStub;
import stubs.javax.servlet.ServletContextStub;
import stubs.javax.servlet.http.HttpServletRequestStub;
import stubs.javax.servlet.http.HttpSessionStub;

public class ConfigurationBeanLoaderTest
extends AbstractTestClass {
    private static final String GENERIC_INSTANCE_URI = "http://mytest.edu/some_instance";
    private static final String GENERIC_PROPERTY_URI = "http://mytest.edu/some_property";
    private static final String SIMPLE_SUCCESS_INSTANCE_URI = "http://mytest.edu/simple_success_instance";
    private static final String FULL_SUCCESS_INSTANCE_URI = "http://mytest.edu/full_success_instance";
    private static final String FULL_SUCCESS_BOOST_PROPERTY = "http://mydomain.edu/hasBoost";
    private static final String FULL_SUCCESS_TEXT_PROPERTY = "http://mydomain.edu/hasText";
    private static final String FULL_SUCCESS_HELPER_PROPERTY = "http://mydomain.edu/hasHelper";
    private static final String FULL_SUCCESS_HELPER_INSTANCE_URI = "http://mytest.edu/full_success_helper_instance";
    private ServletContextStub ctx;
    private HttpSessionStub session;
    private HttpServletRequestStub req;
    private Model model;
    private ConfigurationBeanLoader loader;
    private ConfigurationBeanLoader noRequestLoader;
    private ConfigurationBeanLoader noContextLoader;
    private static final Statement[] FULL_SUCCESS_STATEMENTS = new Statement[]{ModelUtilitiesTestHelper.typeStatement("http://mytest.edu/full_success_instance", ConfigurationBeanLoader.toJavaUri(FullSuccessResultClass.class)), ModelUtilitiesTestHelper.typeStatement("http://mytest.edu/full_success_instance", ConfigurationBeanLoader.toJavaUri(FullSuccessConcreteClass.class)), ModelUtilitiesTestHelper.dataProperty("http://mytest.edu/full_success_instance", "http://mydomain.edu/hasBoost", Float.valueOf(1.5f), XSDDatatype.XSDfloat), ModelUtilitiesTestHelper.dataProperty("http://mytest.edu/full_success_instance", "http://mydomain.edu/hasBoost", Float.valueOf(-99.0f), XSDDatatype.XSDfloat), ModelUtilitiesTestHelper.dataProperty("http://mytest.edu/full_success_instance", "http://mydomain.edu/hasText", (Object)"Huey", XSDDatatype.XSDstring), ModelUtilitiesTestHelper.dataProperty("http://mytest.edu/full_success_instance", "http://mydomain.edu/hasText", "Dewey", "en-US"), ModelUtilitiesTestHelper.dataProperty("http://mytest.edu/full_success_instance", "http://mydomain.edu/hasText", "Louis"), ModelUtilitiesTestHelper.objectProperty("http://mytest.edu/full_success_instance", "http://mydomain.edu/hasHelper", "http://mytest.edu/full_success_helper_instance"), ModelUtilitiesTestHelper.typeStatement("http://mytest.edu/full_success_helper_instance", ConfigurationBeanLoader.toJavaUri(FullSuccessHelperResultClass.class)), ModelUtilitiesTestHelper.typeStatement("http://mytest.edu/full_success_helper_instance", ConfigurationBeanLoader.toJavaUri(FullSuccessHelperConcreteClass.class))};

    @Before
    public void setup() {
        this.ctx = new ServletContextStub();
        this.session = new HttpSessionStub();
        this.session.setServletContext(this.ctx);
        this.req = new HttpServletRequestStub();
        this.req.setSession(this.session);
        ModelAccessFactoryStub maf = new ModelAccessFactoryStub();
        this.model = ModelUtilitiesTestHelper.model(new Statement[0]);
        this.loader = new ConfigurationBeanLoader(this.model, (HttpServletRequest)this.req);
        this.noRequestLoader = new ConfigurationBeanLoader(this.model, (ServletContext)this.ctx);
        this.noContextLoader = new ConfigurationBeanLoader(this.model);
    }

    @Test
    public void constructor_modelIsNull_throwsException() {
        this.expectException(NullPointerException.class, "model may not be null");
        ConfigurationBeanLoader unused = new ConfigurationBeanLoader((Model)null);
    }

    @Test
    public void loadInstance_uriIsNull_throwsException() throws ConfigurationBeanLoaderException {
        this.expectException(NullPointerException.class, "uri may not be null");
        Object unused = this.loader.loadInstance(null, SimpleSuccess.class);
    }

    @Test
    public void load_instance_resultClassIsNull_throwsException() throws ConfigurationBeanLoaderException {
        this.expectException(NullPointerException.class, "resultClass may not be null");
        Object unused = this.loader.loadInstance(GENERIC_INSTANCE_URI, null);
    }

    @Test
    public void noStatementsAboutUri_throwsException() throws ConfigurationBeanLoaderException {
        this.expectSimpleFailure(SimpleSuccess.class, this.throwable(ConfigurationBeanLoaderException.class, "Failed to load"), this.throwable(ConfigurationRdfParser.InvalidConfigurationRdfException.class, "The model contains no statements about"));
    }

    @Test
    public void uriDoesNotDeclareResultClassAsType_throwsException() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.dataProperty(GENERIC_INSTANCE_URI, "http://some.simple/property", "a value"));
        this.expectSimpleFailure(SimpleSuccess.class, this.throwable(ConfigurationBeanLoaderException.class, "Failed to load"), this.throwable(ConfigurationRdfParser.InvalidConfigurationRdfException.class, "A type statement is required"));
    }

    @Test
    public void uriHasNoConcreteType_throwsException() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement(GENERIC_INSTANCE_URI, ConfigurationBeanLoader.toJavaUri(SimpleInterfaceFailure.class)));
        this.expectSimpleFailure(SimpleInterfaceFailure.class, this.throwable(ConfigurationBeanLoaderException.class, "Failed to load"), this.throwable(ConfigurationRdfParser.InvalidConfigurationRdfException.class, "No concrete class is declared"));
    }

    @Test
    public void uriHasMultipleConcreteTypes_throwsException() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement(GENERIC_INSTANCE_URI, ConfigurationBeanLoader.toJavaUri(SimpleSuccess.class)));
        this.model.add(ModelUtilitiesTestHelper.typeStatement(GENERIC_INSTANCE_URI, ConfigurationBeanLoader.toJavaUri(SecondConcreteClass.class)));
        this.expectSimpleFailure(SimpleSuccess.class, this.throwable(ConfigurationBeanLoaderException.class, "Failed to load"), this.throwable(ConfigurationRdfParser.InvalidConfigurationRdfException.class, "more than one concrete class"));
    }

    @Test
    public void cantLoadConcreteType_throwsException() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement(GENERIC_INSTANCE_URI, ConfigurationBeanLoader.toJavaUri(UnloadableClass.class)));
        this.expectSimpleFailure(UnloadableClass.class, this.throwable(ConfigurationBeanLoaderException.class, "Failed to load"), this.throwable(ConfigurationRdfParser.InvalidConfigurationRdfException.class, "Can't load this type"));
    }

    @Test
    public void concreteTypeNotAssignableToResultClass_throwsException() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement(GENERIC_INSTANCE_URI, ConfigurationBeanLoader.toJavaUri(SimpleSuccess.class)));
        this.model.add(ModelUtilitiesTestHelper.typeStatement(GENERIC_INSTANCE_URI, ConfigurationBeanLoader.toJavaUri(String.class)));
        this.expectSimpleFailure(SimpleSuccess.class, this.throwable(ConfigurationBeanLoaderException.class, "Failed to load"), this.throwable(ConfigurationRdfParser.InvalidConfigurationRdfException.class, "cannot be assigned to class"));
    }

    @Test
    public void noNiladicConstructor_throwsException() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement(GENERIC_INSTANCE_URI, ConfigurationBeanLoader.toJavaUri(NoNiladicConstructor.class)));
        this.expectSimpleFailure(NoNiladicConstructor.class, this.throwable(ConfigurationBeanLoaderException.class, "Failed to load"), this.throwable(ConfigurationRdfParser.InvalidConfigurationRdfException.class, "no zero-argument constructor."));
    }

    @Test
    public void niladicConstructorNotAccessible_throwsException() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement(GENERIC_INSTANCE_URI, ConfigurationBeanLoader.toJavaUri(PrivateConstructor.class)));
        this.expectSimpleFailure(PrivateConstructor.class, this.throwable(ConfigurationBeanLoaderException.class, "Failed to load"), this.throwable(ConfigurationRdfParser.InvalidConfigurationRdfException.class, "no zero-argument constructor."));
    }

    @Test
    public void constructorThrowsException_throwsException() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement(GENERIC_INSTANCE_URI, ConfigurationBeanLoader.toJavaUri(ConstructorFails.class)));
        this.expectSimpleFailure(ConstructorFails.class, this.throwable(ConfigurationBeanLoaderException.class, "Failed to load"), this.throwable(InstanceWrapper.InstanceWrapperException.class, "Failed to create an instance."));
    }

    @Test
    public void propertyMethodHasNoParameter_throwsException() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement(GENERIC_INSTANCE_URI, ConfigurationBeanLoader.toJavaUri(NoParameterOnPropertyMethod.class)));
        this.expectSimpleFailure(NoParameterOnPropertyMethod.class, this.throwable(ConfigurationBeanLoaderException.class, "Failed to load"), this.throwable(InstanceWrapper.InstanceWrapperException.class, "must accept exactly one parameter"));
    }

    @Test
    public void propertyMethodHasMultipleParameters_throwsException() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement(GENERIC_INSTANCE_URI, ConfigurationBeanLoader.toJavaUri(MultipleParametersOnPropertyMethod.class)));
        this.expectSimpleFailure(MultipleParametersOnPropertyMethod.class, this.throwable(ConfigurationBeanLoaderException.class, "Failed to load"), this.throwable(InstanceWrapper.InstanceWrapperException.class, "must accept exactly one parameter"));
    }

    @Test
    public void propertyMethodHasInvalidParameter_throwsException() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement(GENERIC_INSTANCE_URI, ConfigurationBeanLoader.toJavaUri(InvalidParameterOnPropertyMethod.class)));
        this.expectSimpleFailure(InvalidParameterOnPropertyMethod.class, this.throwable(ConfigurationBeanLoaderException.class, "Failed to load"), this.throwable(InstanceWrapper.InstanceWrapperException.class, "Failed to create the PropertyMethod"));
    }

    @Test
    public void propertyMethodDoesNotReturnVoid_throwsException() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement(GENERIC_INSTANCE_URI, ConfigurationBeanLoader.toJavaUri(PropertyMethodMustReturnVoid.class)));
        this.expectSimpleFailure(PropertyMethodMustReturnVoid.class, this.throwable(ConfigurationBeanLoaderException.class, "Failed to load"), this.throwable(InstanceWrapper.InstanceWrapperException.class, "should return void"));
    }

    @Test
    public void propertyMethodNotAccessible_throwsException() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement(GENERIC_INSTANCE_URI, ConfigurationBeanLoader.toJavaUri(PropertyMethodIsPrivate.class)));
        this.model.add(ModelUtilitiesTestHelper.dataProperty(GENERIC_INSTANCE_URI, GENERIC_PROPERTY_URI, "can't store in a private method."));
        this.expectSimpleFailure(PropertyMethodIsPrivate.class, this.throwable(ConfigurationBeanLoaderException.class, "Failed to load"), this.throwable(PropertyType.PropertyTypeException.class, "Property method failed."));
    }

    @Test
    public void propertyMethodThrowsException_throwsException() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement(GENERIC_INSTANCE_URI, ConfigurationBeanLoader.toJavaUri(PropertyMethodFails.class)));
        this.model.add(ModelUtilitiesTestHelper.dataProperty(GENERIC_INSTANCE_URI, GENERIC_PROPERTY_URI, "exception while loading."));
        this.expectSimpleFailure(PropertyMethodFails.class, this.throwable(ConfigurationBeanLoaderException.class, "Failed to load"), this.throwable(PropertyType.PropertyTypeException.class, "Property method failed."));
    }

    @Test
    public void propertyMethodDuplicateUri_throwsException() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement(GENERIC_INSTANCE_URI, ConfigurationBeanLoader.toJavaUri(TwoMethodsWithSameUri.class)));
        this.expectSimpleFailure(TwoMethodsWithSameUri.class, this.throwable(ConfigurationBeanLoaderException.class, "Failed to load"), this.throwable(InstanceWrapper.InstanceWrapperException.class, "methods have the same URI"));
    }

    @Test
    public void validationMethodHasParameters_throwsException() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement(GENERIC_INSTANCE_URI, ConfigurationBeanLoader.toJavaUri(ValidationMethodWithParameter.class)));
        this.expectSimpleFailure(ValidationMethodWithParameter.class, this.throwable(ConfigurationBeanLoaderException.class, "Failed to load"), this.throwable(InstanceWrapper.InstanceWrapperException.class, "should not have parameters"));
    }

    @Test
    public void validationMethodDoesNotReturnVoid_throwsException() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement(GENERIC_INSTANCE_URI, ConfigurationBeanLoader.toJavaUri(ValidationMethodShouldReturnVoid.class)));
        this.expectSimpleFailure(ValidationMethodShouldReturnVoid.class, this.throwable(ConfigurationBeanLoaderException.class, "Failed to load"), this.throwable(InstanceWrapper.InstanceWrapperException.class, "should return void"));
    }

    @Test
    public void validationMethodNotAccessible_throwsException() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement(GENERIC_INSTANCE_URI, ConfigurationBeanLoader.toJavaUri(ValidationMethodIsPrivate.class)));
        this.expectSimpleFailure(ValidationMethodIsPrivate.class, this.throwable(ConfigurationBeanLoaderException.class, "Failed to load"), this.throwable(WrappedInstance.ValidationFailedException.class, "Error executing validation method"));
    }

    @Test
    public void validationMethodThrowsException_throwsException() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement(GENERIC_INSTANCE_URI, ConfigurationBeanLoader.toJavaUri(ValidationThrowsException.class)));
        this.expectSimpleFailure(ValidationThrowsException.class, this.throwable(ConfigurationBeanLoaderException.class, "Failed to load"), this.throwable(WrappedInstance.ValidationFailedException.class, "Error executing validation method"));
    }

    @Test
    public void loaderCantSatisfyContextModelsUser_throwsException() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement(GENERIC_INSTANCE_URI, ConfigurationBeanLoader.toJavaUri(NeedsContextModels.class)));
        this.loader = this.noContextLoader;
        this.expectSimpleFailure(NeedsContextModels.class, this.throwable(ConfigurationBeanLoaderException.class, "Failed to load"), this.throwable(WrappedInstance.ResourceUnavailableException.class, "Cannot satisfy ContextModelsUser"));
    }

    @Test
    public void loaderCantSatisfyRequestModelsUser_throwsException() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement(GENERIC_INSTANCE_URI, ConfigurationBeanLoader.toJavaUri(NeedsRequestModels.class)));
        this.loader = this.noRequestLoader;
        this.expectSimpleFailure(NeedsRequestModels.class, this.throwable(ConfigurationBeanLoaderException.class, "Failed to load"), this.throwable(WrappedInstance.ResourceUnavailableException.class, "Cannot satisfy RequestModelsUser"));
    }

    @Test
    public void tripleHasUnrecognizedProperty_throwsException() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement(GENERIC_INSTANCE_URI, ConfigurationBeanLoader.toJavaUri(SimpleSuccess.class)));
        this.model.add(ModelUtilitiesTestHelper.dataProperty(GENERIC_INSTANCE_URI, "http://bogus.property/name", "No place to put it."));
        this.expectSimpleFailure(SimpleSuccess.class, this.throwable(ConfigurationBeanLoaderException.class, "Failed to load"), this.throwable(WrappedInstance.NoSuchPropertyMethodException.class, "No property method"));
    }

    @Test
    public void valueTypeDoesNotMatchArgumentOfPropertyMethod_throwsException() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement(GENERIC_INSTANCE_URI, ConfigurationBeanLoader.toJavaUri(ExpectingAString.class)));
        this.model.add(ModelUtilitiesTestHelper.objectProperty(GENERIC_INSTANCE_URI, GENERIC_PROPERTY_URI, "http://some.other/uri"));
        this.expectSimpleFailure(ExpectingAString.class, this.throwable(ConfigurationBeanLoaderException.class, "Failed to load"), this.throwable(PropertyType.PropertyTypeException.class, "type RESOURCE to a method of type STRING"));
    }

    @Test
    public void subordinateObjectCantBeLoaded_throwsException() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement(GENERIC_INSTANCE_URI, ConfigurationBeanLoader.toJavaUri(NoSuchSubordinateInstance.class)));
        this.model.add(ModelUtilitiesTestHelper.objectProperty(GENERIC_INSTANCE_URI, GENERIC_PROPERTY_URI, "http://some.other/uri"));
        this.expectSimpleFailure(NoSuchSubordinateInstance.class, this.throwable(ConfigurationBeanLoaderException.class, "Failed to load"), this.throwable(ConfigurationBeanLoaderException.class, "Failed to load"));
    }

    @Test
    public void simpleSuccess() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement(SIMPLE_SUCCESS_INSTANCE_URI, ConfigurationBeanLoader.toJavaUri(SimpleSuccess.class)));
        SimpleSuccess instance = (SimpleSuccess)this.loader.loadInstance(SIMPLE_SUCCESS_INSTANCE_URI, SimpleSuccess.class);
        Assert.assertNotNull((Object)instance);
    }

    @Test
    public void fullSuccess() throws ConfigurationBeanLoaderException {
        this.model.add(FULL_SUCCESS_STATEMENTS);
        FullSuccessResultClass instance = (FullSuccessResultClass)this.loader.loadInstance(FULL_SUCCESS_INSTANCE_URI, FullSuccessResultClass.class);
        Assert.assertNotNull((Object)instance);
        HashSet<String> expectedTextValues = new HashSet<String>(Arrays.asList("Huey", "Dewey", "Louis"));
        Assert.assertEquals(expectedTextValues, instance.getTextValues());
        HashSet<Float> expectedBoostValues = new HashSet<Float>(Arrays.asList(Float.valueOf(1.5f), Float.valueOf(-99.0f)));
        Assert.assertEquals(expectedBoostValues, instance.getBoostValues());
        Assert.assertEquals((long)1L, (long)instance.getHelpers().size());
        Assert.assertTrue((boolean)instance.isValidated());
    }

    @Test
    public void irrelevantNonConcreteTypesAreIgnored() throws ConfigurationBeanLoaderException {
        this.model.add(new Statement[]{ModelUtilitiesTestHelper.typeStatement(SIMPLE_SUCCESS_INSTANCE_URI, ConfigurationBeanLoader.toJavaUri(SimpleSuccess.class)), ModelUtilitiesTestHelper.typeStatement(SIMPLE_SUCCESS_INSTANCE_URI, ConfigurationBeanLoader.toJavaUri(IrrelevantInterface.class)), ModelUtilitiesTestHelper.typeStatement(SIMPLE_SUCCESS_INSTANCE_URI, ConfigurationBeanLoader.toJavaUri(IrrelevantAbstractClass.class)), ModelUtilitiesTestHelper.typeStatement(SIMPLE_SUCCESS_INSTANCE_URI, "http://irrelevant.nonJava/class")});
        SimpleSuccess instance = (SimpleSuccess)this.loader.loadInstance(SIMPLE_SUCCESS_INSTANCE_URI, SimpleSuccess.class);
        Assert.assertNotNull((Object)instance);
    }

    @Test
    public void loaderHasNoRequestButClassDoesntRequireIt_success() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement(SIMPLE_SUCCESS_INSTANCE_URI, ConfigurationBeanLoader.toJavaUri(SimpleSuccess.class)));
        this.loader = this.noRequestLoader;
        SimpleSuccess instance = (SimpleSuccess)this.loader.loadInstance(SIMPLE_SUCCESS_INSTANCE_URI, SimpleSuccess.class);
        Assert.assertNotNull((Object)instance);
    }

    @Test
    public void loaderHasNoContextButClassDoesntRequireIt_success() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement(SIMPLE_SUCCESS_INSTANCE_URI, ConfigurationBeanLoader.toJavaUri(SimpleSuccess.class)));
        this.loader = this.noContextLoader;
        SimpleSuccess instance = (SimpleSuccess)this.loader.loadInstance(SIMPLE_SUCCESS_INSTANCE_URI, SimpleSuccess.class);
        Assert.assertNotNull((Object)instance);
    }

    @Test
    public void noValuesForProperty_success() throws ConfigurationBeanLoaderException {
        this.model.add(new Statement[]{ModelUtilitiesTestHelper.typeStatement(FULL_SUCCESS_INSTANCE_URI, ConfigurationBeanLoader.toJavaUri(FullSuccessConcreteClass.class)), ModelUtilitiesTestHelper.typeStatement(FULL_SUCCESS_INSTANCE_URI, ConfigurationBeanLoader.toJavaUri(FullSuccessResultClass.class))});
        FullSuccessResultClass instance = (FullSuccessResultClass)this.loader.loadInstance(FULL_SUCCESS_INSTANCE_URI, FullSuccessResultClass.class);
        Assert.assertNotNull((Object)instance);
        Assert.assertEquals(Collections.emptySet(), instance.getTextValues());
        Assert.assertEquals(Collections.emptySet(), instance.getBoostValues());
        Assert.assertEquals(Collections.emptySet(), instance.getHelpers());
        Assert.assertTrue((boolean)instance.isValidated());
    }

    @Test
    public void loadAll_oneObjectCantBeLoaded_throwsException() throws ConfigurationBeanLoaderException {
        this.model.add(new Statement[]{ModelUtilitiesTestHelper.typeStatement("http://apple/good", ConfigurationBeanLoader.toJavaUri(OneBadAppleSpoilsTheBunch.class)), ModelUtilitiesTestHelper.typeStatement("http://apple/good", ConfigurationBeanLoader.toJavaUri(AGoodApple.class)), ModelUtilitiesTestHelper.typeStatement("http://apple/bad", ConfigurationBeanLoader.toJavaUri(OneBadAppleSpoilsTheBunch.class))});
        this.expectException(ConfigurationBeanLoaderException.class, "Failed to load", ConfigurationRdfParser.InvalidConfigurationRdfException.class, "No concrete class is declared");
        this.loader.loadAll(OneBadAppleSpoilsTheBunch.class);
    }

    @Test
    public void loadAll_noResults_success() throws ConfigurationBeanLoaderException {
        Set instances = this.loader.loadAll(SimpleSuccess.class);
        Assert.assertTrue((boolean)instances.isEmpty());
    }

    @Test
    public void loadAll_oneResult_success() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement(GENERIC_INSTANCE_URI, ConfigurationBeanLoader.toJavaUri(SimpleSuccess.class)));
        Set instances = this.loader.loadAll(SimpleSuccess.class);
        Assert.assertEquals((long)1L, (long)instances.size());
    }

    @Test
    public void loadAll_multipleResults_success() throws ConfigurationBeanLoaderException {
        this.model.add(new Statement[]{ModelUtilitiesTestHelper.typeStatement("http://simple.instance/one", ConfigurationBeanLoader.toJavaUri(InstanceWithProperty.class)), ModelUtilitiesTestHelper.dataProperty("http://simple.instance/one", "http://simple.text/property", "FIRST"), ModelUtilitiesTestHelper.typeStatement("http://simple.instance/two", ConfigurationBeanLoader.toJavaUri(InstanceWithProperty.class)), ModelUtilitiesTestHelper.dataProperty("http://simple.instance/two", "http://simple.text/property", "SECOND")});
        Set instances = this.loader.loadAll(InstanceWithProperty.class);
        Assert.assertEquals((long)2L, (long)instances.size());
        HashSet<String> textValues = new HashSet<String>();
        for (InstanceWithProperty instance : instances) {
            textValues.add(instance.getText());
        }
        Assert.assertEquals(new HashSet<String>(Arrays.asList("FIRST", "SECOND")), textValues);
    }

    @Test
    @Ignore
    public void circularReferencesAreNotFatal() throws ConfigurationBeanLoaderException {
        Assert.fail((String)"circularReferencesAreNotFatal not implemented");
    }

    @Test
    @Ignore
    public void subordinateObjectCantBeLoaded_leavesNoAccessibleInstanceOfParent() throws ConfigurationBeanLoaderException {
        Assert.fail((String)"subordinateObjectCantBeLoaded_leavesNoAccessibleInstanceOfParent not implemented");
    }

    @Test
    @Ignore
    public void parentObjectCantBeLoaded_leavesNoAccessibleInstanceOfSubordinate() throws ConfigurationBeanLoaderException {
        Assert.fail((String)"parentObjectCantBeLoaded_leavesNoAccessibleInstanceOfSubordinate not implemented");
    }

    private void expectSimpleFailure(Class<?> failureClass, ExpectedThrowable expected, ExpectedThrowable cause) throws ConfigurationBeanLoaderException {
        this.expectException(expected.getClazz(), expected.getMessageSubstring(), cause.getClazz(), cause.getMessageSubstring());
        Object unused = this.loader.loadInstance(GENERIC_INSTANCE_URI, failureClass);
    }

    private ExpectedThrowable throwable(Class<? extends Throwable> clazz, String messageSubstring) {
        return new ExpectedThrowable(clazz, messageSubstring);
    }

    private static class ExpectedThrowable {
        private final Class<? extends Throwable> clazz;
        private final String messageSubstring;

        public ExpectedThrowable(Class<? extends Throwable> clazz, String messageSubstring) {
            this.clazz = clazz;
            this.messageSubstring = messageSubstring;
        }

        public Class<? extends Throwable> getClazz() {
            return this.clazz;
        }

        public String getMessageSubstring() {
            return this.messageSubstring;
        }
    }

    public static class InstanceWithProperty {
        private String text;

        @Property(uri="http://simple.text/property")
        public void setText(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }
    }

    public static class AGoodApple
    implements OneBadAppleSpoilsTheBunch {
    }

    public static interface OneBadAppleSpoilsTheBunch {
    }

    public abstract class IrrelevantAbstractClass {
    }

    public static interface IrrelevantInterface {
    }

    public static class FullSuccessHelperConcreteClass
    extends FullSuccessHelperResultClass {
    }

    public static abstract class FullSuccessHelperResultClass {
    }

    public static class FullSuccessConcreteClass
    implements FullSuccessResultClass {
        private Set<String> textValues = new HashSet<String>();
        private Set<Float> boostValues = new HashSet<Float>();
        private Set<FullSuccessHelperResultClass> helpers = new HashSet<FullSuccessHelperResultClass>();
        private boolean validatorOneHasRun;
        private boolean validatorTwoHasRun;

        @Property(uri="http://mydomain.edu/hasText")
        public void addText(String text) {
            this.textValues.add(text);
        }

        @Property(uri="http://mydomain.edu/hasBoost")
        public void addBoost(float boost) {
            this.boostValues.add(Float.valueOf(boost));
        }

        @Property(uri="http://mydomain.edu/hasHelper")
        public void addHelper(FullSuccessHelperResultClass helper) {
            this.helpers.add(helper);
        }

        @Validation
        public void validatorOne() {
            if (this.validatorOneHasRun) {
                throw new RuntimeException("validatorOne has already run.");
            }
            this.validatorOneHasRun = true;
        }

        @Validation
        public void validatorTwo() {
            if (this.validatorTwoHasRun) {
                throw new RuntimeException("validatorTwo has already run.");
            }
            this.validatorTwoHasRun = true;
        }

        @Override
        public Set<String> getTextValues() {
            return this.textValues;
        }

        @Override
        public Set<Float> getBoostValues() {
            return this.boostValues;
        }

        @Override
        public Set<FullSuccessHelperResultClass> getHelpers() {
            return this.helpers;
        }

        @Override
        public boolean isValidated() {
            return this.validatorOneHasRun && this.validatorTwoHasRun;
        }
    }

    public static interface FullSuccessResultClass {
        public Set<String> getTextValues();

        public Set<Float> getBoostValues();

        public Set<FullSuccessHelperResultClass> getHelpers();

        public boolean isValidated();
    }

    public static class SimpleSuccess {
    }

    public static class NoSuchSubordinateInstance {
        @Property(uri="http://mytest.edu/some_property")
        public void setHelper(SimpleDateFormat sdf) {
        }
    }

    public static class ExpectingAString {
        @Property(uri="http://mytest.edu/some_property")
        public void setString(String s) {
        }
    }

    public static class NeedsRequestModels
    implements RequestModelsUser {
        public void setRequestModels(RequestModelAccess models) {
        }
    }

    public static class NeedsContextModels
    implements ContextModelsUser {
        public void setContextModels(ContextModelAccess models) {
        }
    }

    public static class ValidationThrowsException {
        @Validation
        public void validateFails() {
            throw new RuntimeException("from validation method");
        }
    }

    public static class ValidationMethodIsPrivate {
        @Validation
        private void validateIsPrivate() {
        }
    }

    public static class ValidationMethodShouldReturnVoid {
        @Validation
        public String validateWithReturnType() {
            return "Hi there!";
        }
    }

    public static class ValidationMethodWithParameter {
        @Validation
        public void validateWithParameter(String s) {
        }
    }

    public static class TwoMethodsWithSameUri {
        @Property(uri="http://mytest.edu/some_property")
        public void firstProperty(String s) {
        }

        @Property(uri="http://mytest.edu/some_property")
        public void secondProperty(String s) {
        }
    }

    public static class PropertyMethodFails {
        @Property(uri="http://mytest.edu/some_property")
        public void methodThrowsException(String s) {
            throw new RuntimeException("property method fails.");
        }
    }

    public static class PropertyMethodIsPrivate {
        @Property(uri="http://mytest.edu/some_property")
        private void methodReturnIsNotVoid(String s) {
        }
    }

    public static class PropertyMethodMustReturnVoid {
        @Property(uri="http://mytest.edu/some_property")
        public String methodReturnIsNotVoid(String s) {
            return s;
        }
    }

    public static class InvalidParameterOnPropertyMethod {
        @Property(uri="http://mytest.edu/some_property")
        public void methodTakesInvalidParameters(byte b) {
        }
    }

    public static class MultipleParametersOnPropertyMethod {
        @Property(uri="http://mytest.edu/some_property")
        public void methodTakesMultipleParameters(String s, Float f) {
        }
    }

    public static class NoParameterOnPropertyMethod {
        @Property(uri="http://mytest.edu/some_property")
        public void methodTakesNoParameters() {
        }
    }

    public static class ConstructorFails {
        public ConstructorFails() {
            throw new IllegalStateException("The constructor throws an exception.");
        }
    }

    public static class PrivateConstructor {
        private PrivateConstructor() {
        }
    }

    public static class NoNiladicConstructor {
        public NoNiladicConstructor(String s) {
        }
    }

    public static class UnloadableClass {
        static {
            throw new IllegalStateException("This class cannot be loaded.");
        }
    }

    public static class SecondConcreteClass
    extends SimpleSuccess {
    }

    public static interface SimpleInterfaceFailure {
    }
}

