/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.ingest;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import edu.cornell.mannlib.vitro.webapp.dao.jena.RDFServiceGraph;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.jena.model.RDFServiceModel;
import edu.cornell.mannlib.vitro.webapp.utils.jena.JenaIngestUtils;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Test;

public class JenaIngestUtilsTest {
    private final Log log = LogFactory.getLog(JenaIngestUtilsTest.class);
    protected JenaIngestUtils utils = new JenaIngestUtils();

    protected Model makeModel() {
        Model base = ModelFactory.createDefaultModel();
        RDFServiceModel rdfService = new RDFServiceModel(base);
        return RDFServiceGraph.createRDFServiceModel((RDFServiceGraph)new RDFServiceGraph((RDFService)rdfService));
    }

    @Test
    public void testSmush() {
        Model model = this.makeModel();
        model.read(JenaIngestUtilsTest.class.getResourceAsStream("smush.start.n3"), null, "N3");
        JenaIngestUtils utils = new JenaIngestUtils();
        Model actualResult = utils.smushResources(model, model.getProperty("http://example.com/ns/duckCode"));
        boolean matchesPossibleResult = false;
        for (int i = 1; i < 7; ++i) {
            Model possibleResult = ModelFactory.createDefaultModel();
            possibleResult.read(JenaIngestUtilsTest.class.getResourceAsStream("smush.end." + i + ".n3"), null, "N3");
            if (!actualResult.isIsomorphicWith(possibleResult)) continue;
            matchesPossibleResult = true;
            break;
        }
        if (!matchesPossibleResult) {
            StringWriter s = new StringWriter();
            actualResult.write((Writer)s, "N3");
            Assert.fail((String)("Smushed model does not match one of the possible results:\n" + s.toString()));
        }
    }

    @Test
    public void testRenameBNodes() {
        Model initialState = ModelFactory.createDefaultModel();
        initialState.read(JenaIngestUtilsTest.class.getResourceAsStream("renameBlank.n3"), null, "N3");
        Model renamedState = this.utils.renameBNodes(initialState, "http://example.org/node/n");
        Assert.assertEquals((String)"Post-rename model is not the same size as the initial model", (long)initialState.size(), (long)renamedState.size());
        StmtIterator sit = renamedState.listStatements();
        boolean lingeringBNodes = false;
        while (sit.hasNext()) {
            Statement stmt = sit.nextStatement();
            if (!stmt.getSubject().isAnon() && !stmt.getObject().isAnon()) continue;
            lingeringBNodes = true;
        }
        if (lingeringBNodes) {
            StringWriter s = new StringWriter();
            renamedState.write((Writer)s, "N3");
            Assert.fail((String)("Renamed model still contains blank nodes \n" + s.toString()));
        }
    }

    @Test
    public void testGenerateTBox() {
        Model abox = ModelFactory.createDefaultModel();
        abox.read(JenaIngestUtilsTest.class.getResourceAsStream("abox.n3"), null, "N3");
        Model tbox = ModelFactory.createDefaultModel();
        tbox.read(JenaIngestUtilsTest.class.getResourceAsStream("tbox.n3"), null, "N3");
        OntModel generatedTBox = this.utils.generateTBox(abox);
        Assert.assertTrue((String)"Generated TBox does not match expected result", (boolean)tbox.isIsomorphicWith((Model)generatedTBox));
    }

    @Test
    public void testDoMerge() {
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM, (Model)this.makeModel());
        OntModel tbox = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM, (Model)this.makeModel());
        model.read(JenaIngestUtilsTest.class.getResourceAsStream("merge.n3"), null, "N3");
        tbox.read(JenaIngestUtilsTest.class.getResourceAsStream("tbox.n3"), null, "N3");
        Model expectedMergeMultipleLabels = model.read(JenaIngestUtilsTest.class.getResourceAsStream("mergeResultMultipleLabels.n3"), null, "N3");
        this.utils.doMerge("http://example.com/ns/n1", "http://example.com/ns/n1", model, tbox, false);
        Assert.assertTrue((String)"Merged model with multiple labels does not match expected result", (boolean)expectedMergeMultipleLabels.isIsomorphicWith((Model)model));
        model = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM, (Model)this.makeModel());
        model.read(JenaIngestUtilsTest.class.getResourceAsStream("merge.n3"), null, "N3");
        Model expectedMergeSingleLabel = model.read(JenaIngestUtilsTest.class.getResourceAsStream("mergeResultSingleLabel.n3"), null, "N3");
        this.utils.doMerge("http://example.com/ns/n1", "http://example.com/ns/n1", model, tbox, true);
        Assert.assertTrue((String)"Merged model with multiple labels does not match expected result", (boolean)expectedMergeSingleLabel.isIsomorphicWith((Model)model));
    }
}

