/*
 * Decompiled with CFR 0.152.
 */
package stubs.edu.cornell.mannlib.vitro.webapp.auth.policy.bean;

import com.hp.hpl.jena.rdf.model.impl.Util;
import edu.cornell.mannlib.vitro.webapp.auth.policy.bean.PropertyRestrictionBean;
import edu.cornell.mannlib.vitro.webapp.auth.policy.bean.PropertyRestrictionLevels;
import edu.cornell.mannlib.vitro.webapp.beans.BaseResourceBean;
import edu.cornell.mannlib.vitro.webapp.beans.Property;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class PropertyRestrictionBeanStub
extends PropertyRestrictionBean {
    private final Set<String> restrictedNamespaces;
    private final Set<String> restrictedProperties;

    public static PropertyRestrictionBean getInstance() {
        return PropertyRestrictionBeanStub.getInstance(null, null);
    }

    public static PropertyRestrictionBeanStub getInstance(String[] restrictedNamespaces) {
        return PropertyRestrictionBeanStub.getInstance(restrictedNamespaces, null);
    }

    public static PropertyRestrictionBeanStub getInstance(String[] restrictedNamespaces, String[] restrictedProperties) {
        PropertyRestrictionBeanStub stub = new PropertyRestrictionBeanStub(restrictedNamespaces, restrictedProperties);
        PropertyRestrictionBean.instance = stub;
        return stub;
    }

    private PropertyRestrictionBeanStub(String[] restrictedNamespaces, String[] restrictedProperties) {
        this.restrictedNamespaces = restrictedNamespaces == null ? Collections.emptySet() : new HashSet<String>(Arrays.asList(restrictedNamespaces));
        this.restrictedProperties = restrictedProperties == null ? Collections.emptySet() : new HashSet<String>(Arrays.asList(restrictedProperties));
    }

    private boolean isPermittedNamespace(String uri) {
        return !this.restrictedNamespaces.contains(this.namespace(uri));
    }

    private String namespace(String uri) {
        return uri.substring(0, Util.splitNamespace((String)uri));
    }

    private boolean isPermittedProperty(String uri) {
        return !this.restrictedProperties.contains(uri);
    }

    public boolean canDisplayResource(String resourceUri, BaseResourceBean.RoleLevel userRole) {
        return this.isPermittedNamespace(resourceUri);
    }

    public boolean canModifyResource(String resourceUri, BaseResourceBean.RoleLevel userRole) {
        return this.isPermittedNamespace(resourceUri) && this.isPermittedProperty(resourceUri);
    }

    public boolean canPublishResource(String resourceUri, BaseResourceBean.RoleLevel userRole) {
        return this.isPermittedNamespace(resourceUri);
    }

    public boolean canDisplayPredicate(Property predicate, BaseResourceBean.RoleLevel userRole) {
        return this.isPermittedNamespace(predicate.getURI());
    }

    public boolean canModifyPredicate(Property predicate, BaseResourceBean.RoleLevel userRole) {
        return this.isPermittedNamespace(predicate.getURI()) && this.isPermittedProperty(predicate.getURI());
    }

    public boolean canPublishPredicate(Property predicate, BaseResourceBean.RoleLevel userRole) {
        return this.isPermittedNamespace(predicate.getURI());
    }

    public void updateProperty(PropertyRestrictionLevels levels) {
        throw new RuntimeException("PropertyRestrictionBeanStub.updateProperty() not implemented.");
    }
}

