/*
 * Decompiled with CFR 0.152.
 */
package stubs.edu.cornell.mannlib.vitro.webapp.beans;

import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import edu.cornell.mannlib.vitro.webapp.beans.BaseResourceBean;
import edu.cornell.mannlib.vitro.webapp.beans.DataProperty;
import edu.cornell.mannlib.vitro.webapp.beans.DataPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.DataPropertyStatementImpl;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectPropertyStatementImpl;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class IndividualStub
implements Individual {
    private final String uri;
    private final String namespace;
    private final String localName;
    private final Set<DataPropertyStatement> dpsSet = new HashSet<DataPropertyStatement>();
    private final Set<ObjectPropertyStatement> opsSet = new HashSet<ObjectPropertyStatement>();
    private final Set<VClass> vClasses = new HashSet<VClass>();
    private String name = "NoName";

    public IndividualStub(String uri) {
        this.uri = uri;
        Resource r = ResourceFactory.createResource((String)uri);
        this.namespace = r.getNameSpace();
        this.localName = r.getLocalName();
    }

    public void addDataPropertyStatement(String predicateUri, String object) {
        this.dpsSet.add((DataPropertyStatement)new DataPropertyStatementImpl(this.uri, predicateUri, object));
    }

    public void addObjectPropertyStatement(ObjectProperty property, String objectUri) {
        ObjectPropertyStatementImpl ops = new ObjectPropertyStatementImpl();
        ops.setSubject((Individual)this);
        ops.setProperty(property);
        ops.setObjectURI(objectUri);
        this.opsSet.add((ObjectPropertyStatement)ops);
    }

    public void addVclass(String ns, String localname, String vClassName) {
        this.vClasses.add(new VClass(ns, localname, vClassName));
    }

    public String getURI() {
        return this.uri;
    }

    public boolean isAnonymous() {
        return this.uri == null || "http://vitro.mannlib.cornell.edu/ns/bnode#".equals(this.getNamespace());
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.getName();
    }

    public String getPickListName() {
        return this.getName();
    }

    public List<DataPropertyStatement> getDataPropertyStatements() {
        return new ArrayList<DataPropertyStatement>(this.dpsSet);
    }

    public List<DataPropertyStatement> getDataPropertyStatements(String propertyUri) {
        ArrayList<DataPropertyStatement> list = new ArrayList<DataPropertyStatement>();
        for (DataPropertyStatement dps : this.dpsSet) {
            if (!dps.getDatapropURI().equals(propertyUri)) continue;
            list.add(dps);
        }
        return list;
    }

    public String getDataValue(String propertyUri) {
        for (DataPropertyStatement dps : this.dpsSet) {
            if (!dps.getDatapropURI().equals(propertyUri)) continue;
            return dps.getData();
        }
        return null;
    }

    public List<ObjectPropertyStatement> getObjectPropertyStatements() {
        return new ArrayList<ObjectPropertyStatement>(this.opsSet);
    }

    public List<ObjectPropertyStatement> getObjectPropertyStatements(String propertyUri) {
        ArrayList<ObjectPropertyStatement> list = new ArrayList<ObjectPropertyStatement>();
        for (ObjectPropertyStatement ops : this.opsSet) {
            if (!ops.getPropertyURI().equals(propertyUri)) continue;
            list.add(ops);
        }
        return list;
    }

    public Individual getRelatedIndividual(String propertyUri) {
        for (ObjectPropertyStatement ops : this.opsSet) {
            if (!ops.getPropertyURI().equals(propertyUri)) continue;
            return ops.getObject();
        }
        return null;
    }

    public boolean isVClass(String vclassUri) {
        for (VClass vc : this.vClasses) {
            if (!vc.getURI().equals(vclassUri)) continue;
            return true;
        }
        return false;
    }

    public List<VClass> getVClasses(boolean direct) {
        return new ArrayList<VClass>(this.vClasses);
    }

    public void sortForDisplay() {
    }

    public VClass getVClass() {
        Iterator<VClass> iterator = this.vClasses.iterator();
        if (iterator.hasNext()) {
            VClass vc = iterator.next();
            return vc;
        }
        return null;
    }

    public String getVClassURI() {
        Iterator<VClass> iterator = this.vClasses.iterator();
        if (iterator.hasNext()) {
            VClass vc = iterator.next();
            return vc.getURI();
        }
        return null;
    }

    public List<VClass> getVClasses() {
        return new ArrayList<VClass>(this.vClasses);
    }

    public void resolveAsFauxPropertyStatements(List<ObjectPropertyStatement> list) {
    }

    public void setURI(String URI2) {
        throw new RuntimeException("IndividualStub.setURI() not implemented.");
    }

    public void setNamespace(String namespace) {
        throw new RuntimeException("IndividualStub.setNamespace() not implemented.");
    }

    public void setLocalName(String localName) {
        throw new RuntimeException("IndividualStub.setLocalName() not implemented.");
    }

    public BaseResourceBean.RoleLevel getHiddenFromDisplayBelowRoleLevel() {
        throw new RuntimeException("IndividualStub.getHiddenFromDisplayBelowRoleLevel() not implemented.");
    }

    public void setHiddenFromDisplayBelowRoleLevel(BaseResourceBean.RoleLevel eR) {
        throw new RuntimeException("IndividualStub.setHiddenFromDisplayBelowRoleLevel() not implemented.");
    }

    public void setHiddenFromDisplayBelowRoleLevelUsingRoleUri(String roleUri) {
        throw new RuntimeException("IndividualStub.setHiddenFromDisplayBelowRoleLevelUsingRoleUri() not implemented.");
    }

    public BaseResourceBean.RoleLevel getProhibitedFromUpdateBelowRoleLevel() {
        throw new RuntimeException("IndividualStub.getProhibitedFromUpdateBelowRoleLevel() not implemented.");
    }

    public void setProhibitedFromUpdateBelowRoleLevel(BaseResourceBean.RoleLevel eR) {
        throw new RuntimeException("IndividualStub.setProhibitedFromUpdateBelowRoleLevel() not implemented.");
    }

    public void setProhibitedFromUpdateBelowRoleLevelUsingRoleUri(String roleUri) {
        throw new RuntimeException("IndividualStub.setProhibitedFromUpdateBelowRoleLevelUsingRoleUri() not implemented.");
    }

    public BaseResourceBean.RoleLevel getHiddenFromPublishBelowRoleLevel() {
        throw new RuntimeException("IndividualStub.getHiddenFromPublishBelowRoleLevel() not implemented.");
    }

    public void setHiddenFromPublishBelowRoleLevel(BaseResourceBean.RoleLevel eR) {
        throw new RuntimeException("IndividualStub.setHiddenFromPublishBelowRoleLevel() not implemented.");
    }

    public void setHiddenFromPublishBelowRoleLevelUsingRoleUri(String roleUri) {
        throw new RuntimeException("IndividualStub.setHiddenFromPublishBelowRoleLevelUsingRoleUri() not implemented.");
    }

    public int compareTo(Individual o) {
        throw new RuntimeException("Comparable<Individual>.compareTo() not implemented.");
    }

    public List<String> getMostSpecificTypeURIs() {
        throw new RuntimeException("Individual.getMostSpecificTypeURIs() not implemented.");
    }

    public String getRdfsLabel() {
        throw new RuntimeException("Individual.getRdfsLabel() not implemented.");
    }

    public void setVClassURI(String in) {
        throw new RuntimeException("Individual.setVClassURI() not implemented.");
    }

    public Timestamp getModTime() {
        throw new RuntimeException("Individual.getModTime() not implemented.");
    }

    public void setModTime(Timestamp in) {
        throw new RuntimeException("Individual.setModTime() not implemented.");
    }

    public List<ObjectProperty> getObjectPropertyList() {
        throw new RuntimeException("Individual.getObjectPropertyList() not implemented.");
    }

    public void setPropertyList(List<ObjectProperty> propertyList) {
        throw new RuntimeException("Individual.setPropertyList() not implemented.");
    }

    public List<ObjectProperty> getPopulatedObjectPropertyList() {
        throw new RuntimeException("Individual.getPopulatedObjectPropertyList() not implemented.");
    }

    public void setPopulatedObjectPropertyList(List<ObjectProperty> propertyList) {
        throw new RuntimeException("Individual.setPopulatedObjectPropertyList() not implemented.");
    }

    public Map<String, ObjectProperty> getObjectPropertyMap() {
        throw new RuntimeException("Individual.getObjectPropertyMap() not implemented.");
    }

    public void setObjectPropertyMap(Map<String, ObjectProperty> propertyMap) {
        throw new RuntimeException("Individual.setObjectPropertyMap() not implemented.");
    }

    public List<DataProperty> getDataPropertyList() {
        throw new RuntimeException("Individual.getDataPropertyList() not implemented.");
    }

    public void setDatatypePropertyList(List<DataProperty> datatypePropertyList) {
        throw new RuntimeException("Individual.setDatatypePropertyList() not implemented.");
    }

    public List<DataProperty> getPopulatedDataPropertyList() {
        throw new RuntimeException("Individual.getPopulatedDataPropertyList() not implemented.");
    }

    public void setPopulatedDataPropertyList(List<DataProperty> dataPropertyList) {
        throw new RuntimeException("Individual.setPopulatedDataPropertyList() not implemented.");
    }

    public Map<String, DataProperty> getDataPropertyMap() {
        throw new RuntimeException("Individual.getDataPropertyMap() not implemented.");
    }

    public void setDataPropertyMap(Map<String, DataProperty> propertyMap) {
        throw new RuntimeException("Individual.setDataPropertyMap() not implemented.");
    }

    public void setDataPropertyStatements(List<DataPropertyStatement> list) {
        throw new RuntimeException("Individual.setDataPropertyStatements() not implemented.");
    }

    public DataPropertyStatement getDataPropertyStatement(String propertyUri) {
        throw new RuntimeException("Individual.getDataPropertyStatement() not implemented.");
    }

    public List<String> getDataValues(String propertyUri) {
        throw new RuntimeException("Individual.getDataValues() not implemented.");
    }

    public void setVClass(VClass class1) {
        throw new RuntimeException("Individual.setVClass() not implemented.");
    }

    public void setVClasses(List<VClass> vClassList, boolean direct) {
        throw new RuntimeException("Individual.setVClasses() not implemented.");
    }

    public void setObjectPropertyStatements(List<ObjectPropertyStatement> list) {
        throw new RuntimeException("Individual.setObjectPropertyStatements() not implemented.");
    }

    public List<Individual> getRelatedIndividuals(String propertyUri) {
        throw new RuntimeException("Individual.getRelatedIndividuals() not implemented.");
    }

    public List<DataPropertyStatement> getExternalIds() {
        throw new RuntimeException("Individual.getExternalIds() not implemented.");
    }

    public void setExternalIds(List<DataPropertyStatement> externalIds) {
        throw new RuntimeException("Individual.setExternalIds() not implemented.");
    }

    public void setMainImageUri(String mainImageUri) {
        throw new RuntimeException("Individual.setMainImageUri() not implemented.");
    }

    public String getMainImageUri() {
        throw new RuntimeException("Individual.getMainImageUri() not implemented.");
    }

    public String getImageUrl() {
        throw new RuntimeException("Individual.getImageUrl() not implemented.");
    }

    public String getThumbUrl() {
        throw new RuntimeException("Individual.getThumbUrl() not implemented.");
    }

    public boolean hasThumb() {
        throw new RuntimeException("Individual.hasThumb() not implemented.");
    }

    public JSONObject toJSON() throws JSONException {
        throw new RuntimeException("Individual.toJSON() not implemented.");
    }

    public Float getSearchBoost() {
        throw new RuntimeException("Individual.getSearchBoost() not implemented.");
    }

    public void setSearchBoost(Float boost) {
        throw new RuntimeException("Individual.setSearchBoost() not implemented.");
    }

    public String getSearchSnippet() {
        throw new RuntimeException("Individual.getSearchSnippet() not implemented.");
    }

    public void setSearchSnippet(String snippet) {
        throw new RuntimeException("Individual.setSearchSnippet() not implemented.");
    }

    public void setRdfsLabel(String in) {
        throw new RuntimeException("IndividualStub.setRdfsLabel() not implemented.");
    }
}

