/*
 * Decompiled with CFR 0.152.
 */
package stubs.javax.naming;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import stubs.javax.naming.InitialContextStub;

public class ContextStub
implements Context {
    private static final Map<String, ContextStub> instances = new HashMap<String, ContextStub>();
    private final String contextPath;
    private final InitialContextStub parent;

    static ContextStub getInstance(String contextPath, InitialContextStub parent) {
        if (!instances.containsKey(contextPath)) {
            instances.put(contextPath, new ContextStub(contextPath, parent));
        }
        return instances.get(contextPath);
    }

    private ContextStub(String contextPath, InitialContextStub parent) {
        this.contextPath = contextPath;
        this.parent = parent;
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        if (name == null) {
            throw new NullPointerException("ContextStub: name may not be null.");
        }
        if (this.isEmpty(name)) {
            throw new NamingException("ContextStub: name may not be empty.");
        }
        this.parent.rebind(this.contextPath + "/" + name, obj);
    }

    @Override
    public Object lookup(String name) throws NamingException {
        if (name == null) {
            throw new NamingException("ContextStub: name may not be null.");
        }
        if (this.isEmpty(name)) {
            return this;
        }
        return this.parent.lookup(this.contextPath + "/" + name);
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        throw new RuntimeException("ContextStub.addToEnvironment() not implemented.");
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        throw new RuntimeException("ContextStub.bind() not implemented.");
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        throw new RuntimeException("ContextStub.bind() not implemented.");
    }

    @Override
    public void close() throws NamingException {
        throw new RuntimeException("ContextStub.close() not implemented.");
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        throw new RuntimeException("ContextStub.composeName() not implemented.");
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        throw new RuntimeException("ContextStub.composeName() not implemented.");
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        throw new RuntimeException("ContextStub.createSubcontext() not implemented.");
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        throw new RuntimeException("ContextStub.createSubcontext() not implemented.");
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        throw new RuntimeException("ContextStub.destroySubcontext() not implemented.");
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        throw new RuntimeException("ContextStub.destroySubcontext() not implemented.");
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        throw new RuntimeException("ContextStub.getEnvironment() not implemented.");
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        throw new RuntimeException("ContextStub.getNameInNamespace() not implemented.");
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        throw new RuntimeException("ContextStub.getNameParser() not implemented.");
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        throw new RuntimeException("ContextStub.getNameParser() not implemented.");
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        throw new RuntimeException("ContextStub.list() not implemented.");
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        throw new RuntimeException("ContextStub.list() not implemented.");
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        throw new RuntimeException("ContextStub.listBindings() not implemented.");
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        throw new RuntimeException("ContextStub.listBindings() not implemented.");
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        throw new RuntimeException("ContextStub.lookup() not implemented.");
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        throw new RuntimeException("ContextStub.lookupLink() not implemented.");
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        throw new RuntimeException("ContextStub.lookupLink() not implemented.");
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        throw new RuntimeException("ContextStub.rebind() not implemented.");
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        throw new RuntimeException("ContextStub.removeFromEnvironment() not implemented.");
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        throw new RuntimeException("ContextStub.rename() not implemented.");
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        throw new RuntimeException("ContextStub.rename() not implemented.");
    }

    @Override
    public void unbind(Name name) throws NamingException {
        throw new RuntimeException("ContextStub.unbind() not implemented.");
    }

    @Override
    public void unbind(String name) throws NamingException {
        throw new RuntimeException("ContextStub.unbind() not implemented.");
    }

    private boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }
}

