/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vedit.validator.impl;

import edu.cornell.mannlib.vedit.validator.ValidationObject;
import edu.cornell.mannlib.vedit.validator.Validator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XMLNameValidator
implements Validator {
    private static final String ERR_MSG = "Must start with a letter or '_' and use only letters, digits, '.', '-' or '_'. No spaces allowed.";
    Pattern pat = Pattern.compile("[A-Za-z_][A-Za-z0-9_\\-\\.]*");
    boolean permitEmpty = false;

    public XMLNameValidator() {
    }

    public XMLNameValidator(boolean permitEmpty) {
        this();
        this.permitEmpty = permitEmpty;
    }

    @Override
    public ValidationObject validate(Object obj) throws IllegalArgumentException {
        ValidationObject vo = new ValidationObject();
        String theString = null;
        try {
            theString = (String)obj;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Expected instance of String");
        }
        if (this.permitEmpty && (theString == null || "".equals(theString))) {
            vo.setValid(true);
        } else {
            Matcher mat = this.pat.matcher(theString);
            if (mat.matches()) {
                vo.setValid(true);
            } else {
                vo.setValid(false);
                vo.setMessage(ERR_MSG);
            }
        }
        vo.setValidatedObject(obj);
        return vo;
    }
}

