/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.application;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import edu.cornell.mannlib.vitro.webapp.application.ApplicationImpl;
import edu.cornell.mannlib.vitro.webapp.application.ApplicationUtils;
import edu.cornell.mannlib.vitro.webapp.application.VitroHomeDirectory;
import edu.cornell.mannlib.vitro.webapp.startup.StartupStatus;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.ConfigurationBeanLoader;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.ConfigurationBeanLoaderException;
import edu.cornell.mannlib.vitro.webapp.utils.jena.criticalsection.LockableModel;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public class ApplicationSetup
implements ServletContextListener {
    private static final String APPLICATION_SETUP_PATH = "config/applicationSetup.n3";
    private ServletContext ctx;
    private StartupStatus ss;
    private ApplicationImpl app;
    private VitroHomeDirectory vitroHomeDir;
    private Path configFile;
    private LockableModel configModel;
    private ConfigurationBeanLoader loader;

    public void contextInitialized(ServletContextEvent sce) {
        try {
            this.ctx = sce.getServletContext();
            this.ss = StartupStatus.getBean(this.ctx);
            this.vitroHomeDir = VitroHomeDirectory.find(this.ctx);
            this.ss.info(this, this.vitroHomeDir.getDiscoveryMessage());
            this.locateApplicationConfigFile();
            this.loadApplicationConfigFile();
            this.createConfigurationBeanLoader();
            this.instantiateTheApplication();
            this.app.setServletContext(this.ctx);
            this.app.setHomeDirectory(this.vitroHomeDir);
            ApplicationUtils.setInstance(this.app);
            this.ss.info(this, "Application is configured.");
        }
        catch (Exception e) {
            this.ss.fatal(this, "Failed to initialize the Application.", e);
        }
    }

    private void locateApplicationConfigFile() {
        Path path = this.vitroHomeDir.getPath().resolve(APPLICATION_SETUP_PATH);
        if (!Files.exists(path, new LinkOption[0])) {
            throw new IllegalStateException("'" + path + "' does not exist.");
        }
        if (!Files.isReadable(path)) {
            throw new IllegalStateException("Can't read '" + path + "'");
        }
        this.configFile = path;
    }

    private void loadApplicationConfigFile() {
        try (InputStream in = Files.newInputStream(this.configFile, new OpenOption[0]);){
            Model m = ModelFactory.createDefaultModel();
            m.read(in, null, "N3");
            this.configModel = new LockableModel(m);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read '" + this.configFile + "'", e);
        }
    }

    private void createConfigurationBeanLoader() {
        this.loader = new ConfigurationBeanLoader(this.configModel);
    }

    private void instantiateTheApplication() {
        try {
            Set<ApplicationImpl> apps = this.loader.loadAll(ApplicationImpl.class);
            if (apps.isEmpty()) {
                throw new IllegalStateException("'" + this.configFile + "' does not define an instance of " + ApplicationImpl.class.getName());
            }
            if (apps.size() > 1) {
                throw new IllegalStateException("'" + this.configFile + "' defines " + apps.size() + " instances of " + ApplicationImpl.class.getName());
            }
            this.app = apps.iterator().next();
        }
        catch (ConfigurationBeanLoaderException e) {
            throw new IllegalStateException("Failed to setup the application", e);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }
}

