/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.application;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BuildProperties {
    private static final Log log = LogFactory.getLog(BuildProperties.class);
    public static final String WEBAPP_PATH_BUILD_PROPERTIES = "/WEB-INF/resources/build.properties";
    private final Map<String, String> propertyMap;

    public BuildProperties(ServletContext ctx) {
        HashMap<String, String> map = new HashMap<String, String>();
        try (InputStream stream = ctx.getResourceAsStream(WEBAPP_PATH_BUILD_PROPERTIES);){
            if (stream == null) {
                log.debug((Object)"Didn't find a resource at '/WEB-INF/resources/build.properties'.");
            } else {
                Properties props = new Properties();
                props.load(stream);
                for (String key : props.stringPropertyNames()) {
                    map.put(key, props.getProperty(key));
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load from '/WEB-INF/resources/build.properties'.", e);
        }
        this.propertyMap = Collections.unmodifiableMap(map);
    }

    public Map<String, String> getMap() {
        return this.propertyMap;
    }
}

