/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.application;

import edu.cornell.mannlib.vitro.webapp.application.BuildProperties;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VitroHomeDirectory {
    private static final Log log = LogFactory.getLog(VitroHomeDirectory.class);
    private final ServletContext ctx;
    private final Path path;
    private final String discoveryMessage;

    public static VitroHomeDirectory find(ServletContext ctx) {
        HomeDirectoryFinder finder = new HomeDirectoryFinder(ctx);
        return new VitroHomeDirectory(ctx, finder.getPath(), finder.getMessage());
    }

    public VitroHomeDirectory(ServletContext ctx, Path path, String discoveryMessage) {
        this.ctx = ctx;
        this.path = path;
        this.discoveryMessage = discoveryMessage;
    }

    public ServletContext getCtx() {
        return this.ctx;
    }

    public Path getPath() {
        return this.path;
    }

    public String getDiscoveryMessage() {
        return this.discoveryMessage;
    }

    private static class HomeDirectoryFinder {
        private static final String VHD_JNDI_PATH = "java:comp/env/vitro/home";
        private static final String VHD_SYSTEM_PROPERTY = "vitro.home";
        private static final String VHD_BUILD_PROPERTY = "vitro.home";
        private final ServletContext ctx;
        private final List<Found> foundLocations = new ArrayList<Found>();

        public HomeDirectoryFinder(ServletContext ctx) {
            this.ctx = ctx;
            this.getVhdFromJndi();
            this.getVhdFromSystemProperties();
            this.getVhdFromBuildProperties();
            this.confirmExactlyOneResult();
            this.confirmValidDirectory();
        }

        public String getMessage() {
            return this.foundLocations.get(0).getMessage();
        }

        public Path getPath() {
            return this.foundLocations.get(0).getPath();
        }

        public void getVhdFromJndi() {
            try {
                String vhdPath = (String)new InitialContext().lookup(VHD_JNDI_PATH);
                if (vhdPath == null) {
                    log.debug((Object)"Didn't find a JNDI value at 'java:comp/env/vitro/home'.");
                } else {
                    log.debug((Object)("'java:comp/env/vitro/home' as specified by JNDI: " + vhdPath));
                    String message = String.format("JNDI environment '%s' was set to '%s'", VHD_JNDI_PATH, vhdPath);
                    this.foundLocations.add(new Found(Paths.get(vhdPath, new String[0]), message));
                }
            }
            catch (Exception e) {
                log.debug((Object)("JNDI lookup failed. " + e));
            }
        }

        private void getVhdFromSystemProperties() {
            String vhdPath = System.getProperty("vitro.home");
            if (vhdPath == null) {
                log.debug((Object)"Didn't find a system property value at 'vitro.home'.");
            } else {
                log.debug((Object)("'vitro.home' as specified by system property: " + vhdPath));
                String message = String.format("System property '%s' was set to '%s'", "vitro.home", vhdPath);
                this.foundLocations.add(new Found(Paths.get(vhdPath, new String[0]), message));
            }
        }

        private void getVhdFromBuildProperties() {
            try {
                Map<String, String> buildProps = new BuildProperties(this.ctx).getMap();
                String vhdPath = buildProps.get("vitro.home");
                if (vhdPath == null) {
                    log.debug((Object)"build properties doesn't contain a value for 'vitro.home'.");
                } else {
                    log.debug((Object)("'vitro.home' as specified by build.properties: " + vhdPath));
                    String message = String.format("In resource '%s', '%s' was set to '%s'.", "/WEB-INF/resources/build.properties", "vitro.home", vhdPath);
                    this.foundLocations.add(new Found(Paths.get(vhdPath, new String[0]), message));
                }
            }
            catch (Exception e) {
                log.warn((Object)("Reading build properties failed. " + e));
            }
        }

        private void confirmExactlyOneResult() {
            if (this.foundLocations.isEmpty()) {
                String message = String.format("Can't find a value for the Vitro home directory. Looked in JNDI environment at '%s'. Looked for a system property named '%s'. Looked in 'WEB-INF/resources/build.properties' for '%s'.", VHD_JNDI_PATH, "vitro.home", "vitro.home");
                throw new IllegalStateException(message);
            }
            if (this.foundLocations.size() > 1) {
                String message = String.format("Found multiple values for the Vitro home directory: " + this.foundLocations, new Object[0]);
                log.warn((Object)message);
            }
        }

        private void confirmValidDirectory() {
            Path vhd = this.getPath();
            if (!Files.exists(vhd, new LinkOption[0])) {
                throw new IllegalStateException("Vitro home directory '" + vhd + "' does not exist.");
            }
            if (!Files.isDirectory(vhd, new LinkOption[0])) {
                throw new IllegalStateException("Vitro home directory '" + vhd + "' is not a directory.");
            }
            if (!Files.isReadable(vhd)) {
                throw new IllegalStateException("Cannot read Vitro home directory '" + vhd + "'.");
            }
            if (!Files.isWritable(vhd)) {
                throw new IllegalStateException("Can't write to Vitro home directory: '" + vhd + "'.");
            }
        }

        private static class Found {
            private final Path path;
            private final String message;

            public Found(Path path, String message) {
                this.path = path;
                this.message = message;
            }

            public Path getPath() {
                return this.path;
            }

            public String getMessage() {
                return this.message;
            }

            public String toString() {
                return "Found[path=" + this.path + ", message=" + this.message + "]";
            }
        }
    }
}

