/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.identifier.common;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.Identifier;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.IdentifierBundle;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.common.AbstractCommonIdentifier;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import javax.servlet.ServletContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IsBlacklisted
extends AbstractCommonIdentifier
implements Identifier {
    private static final Log log = LogFactory.getLog(IsBlacklisted.class);
    private static final String BLACKLIST_SPARQL_DIR = "/admin/selfEditBlacklist";
    private static final String NOT_BLACKLISTED = null;
    private final String associatedIndividualUri;
    private final String reasonForBlacklisting;

    public static IsBlacklisted getInstance(Individual individual, ServletContext context) {
        if (individual == null) {
            throw new NullPointerException("individual may not be null.");
        }
        if (context == null) {
            throw new NullPointerException("context may not be null.");
        }
        String reasonForBlacklisting = IsBlacklisted.checkForBlacklisted(individual, context);
        IsBlacklisted id = new IsBlacklisted(individual.getURI(), reasonForBlacklisting);
        if (id.isBlacklisted()) {
            return id;
        }
        return null;
    }

    private static String checkForBlacklisted(Individual ind, ServletContext context) {
        String realPath = context.getRealPath(BLACKLIST_SPARQL_DIR);
        File blacklistDir = new File(realPath);
        if (!blacklistDir.isDirectory() || !blacklistDir.canRead()) {
            log.debug((Object)("cannot read blacklist directory " + realPath));
            return NOT_BLACKLISTED;
        }
        log.debug((Object)("checking directlry " + realPath + " for blacklisting sparql query files"));
        File[] files = blacklistDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".sparql");
            }
        });
        String reasonForBlacklist = NOT_BLACKLISTED;
        for (File file : files) {
            try {
                reasonForBlacklist = IsBlacklisted.runSparqlFileForBlacklist(file, ind, context);
                if (reasonForBlacklist == NOT_BLACKLISTED) continue;
                break;
            }
            catch (RuntimeException ex) {
                log.error((Object)("Could not run blacklist check query for file " + file.getAbsolutePath() + File.separatorChar + file.getName()), (Throwable)ex);
            }
        }
        return reasonForBlacklist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String runSparqlFileForBlacklist(File file, Individual ind, ServletContext context) {
        if (!file.canRead()) {
            log.debug((Object)("cannot read blacklisting SPARQL file " + file.getName()));
            return NOT_BLACKLISTED;
        }
        String queryString = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            byte[] b = new byte[fis.available()];
            fis.read(b);
            queryString = new String(b);
        }
        catch (IOException ioe) {
            log.debug((Object)ioe);
            String string = NOT_BLACKLISTED;
            return string;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    log.warn((Object)"could not close file", (Throwable)e);
                }
            }
        }
        if (StringUtils.isEmpty((String)queryString)) {
            log.debug((Object)(file.getName() + " is empty"));
            return NOT_BLACKLISTED;
        }
        OntModel model = ModelAccess.on(context).getOntModel();
        queryString = queryString.replaceAll("\\?individualURI", "<" + ind.getURI() + ">");
        log.debug((Object)queryString);
        Query query = QueryFactory.create((String)queryString);
        try (QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Model)model);){
            ResultSet results = qexec.execSelect();
            while (results.hasNext()) {
                QuerySolution solution = results.nextSolution();
                if (solution.contains("cause")) {
                    RDFNode node = solution.get("cause");
                    if (node.isResource()) {
                        String string = node.asResource().getURI();
                        return string;
                    }
                    if (!node.isLiteral()) continue;
                    String string = node.asLiteral().getString();
                    return string;
                }
                log.error((Object)"Query solution must contain a variable \"cause\" of type Resource or Literal.");
                String string = NOT_BLACKLISTED;
                return string;
            }
        }
        return NOT_BLACKLISTED;
    }

    public static Collection<IsBlacklisted> getIdentifiers(IdentifierBundle ids) {
        return IsBlacklisted.getIdentifiersForClass(ids, IsBlacklisted.class);
    }

    public static Collection<String> getBlacklistReasons(IdentifierBundle ids) {
        HashSet<String> set = new HashSet<String>();
        for (IsBlacklisted id : IsBlacklisted.getIdentifiers(ids)) {
            if (!id.isBlacklisted()) continue;
            set.add(id.getReasonForBlacklisting());
        }
        return set;
    }

    public IsBlacklisted(String associatedIndividualUri, String reasonForBlacklisting) {
        this.associatedIndividualUri = associatedIndividualUri;
        this.reasonForBlacklisting = reasonForBlacklisting;
    }

    public String getAssociatedIndividualUri() {
        return this.associatedIndividualUri;
    }

    public boolean isBlacklisted() {
        return this.reasonForBlacklisting != NOT_BLACKLISTED;
    }

    public String getReasonForBlacklisting() {
        return this.reasonForBlacklisting;
    }

    public String toString() {
        return "IsBlacklisted[" + this.associatedIndividualUri + ", " + this.reasonForBlacklisting + "]";
    }
}

