/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.policy;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.ActiveIdentifierBundleFactories;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.IdentifierBundle;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.RequestIdentifiers;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ServletPolicyList;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.PolicyIface;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.RequestedAction;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.propstmt.AbstractPropertyStatementAction;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.propstmt.AddDataPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.propstmt.AddObjectPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.propstmt.DropDataPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.propstmt.DropObjectPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.Property;
import edu.cornell.mannlib.vitro.webapp.beans.UserAccount;
import edu.cornell.mannlib.vitro.webapp.controller.authenticate.Authenticator;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PolicyHelper {
    private static final Log log = LogFactory.getLog(PolicyHelper.class);

    public static boolean isAuthorizedForActions(HttpServletRequest req, AuthorizationRequest ... actions) {
        return PolicyHelper.isAuthorizedForActions(req, AuthorizationRequest.andAll(actions));
    }

    public static boolean isAuthorizedForActions(HttpServletRequest req, Iterable<? extends AuthorizationRequest> actions) {
        return PolicyHelper.isAuthorizedForActions(req, AuthorizationRequest.andAll(actions));
    }

    private static boolean isAuthorizedForActions(HttpServletRequest req, AuthorizationRequest ar) {
        PolicyIface policy = ServletPolicyList.getPolicies(req);
        IdentifierBundle ids = RequestIdentifiers.getIdBundleForRequest((ServletRequest)req);
        return ar.isAuthorized(ids, policy);
    }

    public static boolean isAuthorizedForActions(IdentifierBundle ids, PolicyIface policy, AuthorizationRequest ar) {
        return ar.isAuthorized(ids, policy);
    }

    public static boolean isAuthorizedForActions(HttpServletRequest req, String email, String password, AuthorizationRequest ar) {
        if (password == null || email == null || password.isEmpty() || email.isEmpty()) {
            return false;
        }
        try {
            Authenticator auth = Authenticator.getInstance(req);
            UserAccount user = auth.getAccountForInternalAuth(email);
            if (user == null) {
                log.debug((Object)("No account for '" + email + "'"));
                return false;
            }
            String uri = user.getUri();
            log.debug((Object)("userAccount is '" + uri + "'"));
            if (!auth.isCurrentPassword(user, password)) {
                log.debug((Object)String.format("UNAUTHORIZED, password not accepted for %s, account URI: %s", email, uri));
                return false;
            }
            log.debug((Object)String.format("password accepted for %s, account URI: %s", email, uri));
            IdentifierBundle ids = ActiveIdentifierBundleFactories.getUserIdentifierBundle(req, user);
            PolicyIface policy = ServletPolicyList.getPolicies(req);
            return ar.isAuthorized(ids, policy);
        }
        catch (Exception ex) {
            log.error((Object)("Error while attempting to authorize actions " + ar), (Throwable)ex);
            return false;
        }
    }

    public static boolean isAuthorizedToAdd(HttpServletRequest req, Statement stmt, OntModel modelToBeModified) {
        AbstractPropertyStatementAction action;
        if (req == null || stmt == null || modelToBeModified == null) {
            return false;
        }
        Resource subject = stmt.getSubject();
        com.hp.hpl.jena.rdf.model.Property predicate = stmt.getPredicate();
        RDFNode objectNode = stmt.getObject();
        if (subject == null || predicate == null || objectNode == null) {
            return false;
        }
        if (objectNode.isResource()) {
            Property property = new Property(predicate.getURI());
            property.setDomainVClassURI(RequestedAction.SOME_URI);
            property.setRangeVClassURI(RequestedAction.SOME_URI);
            action = new AddObjectPropertyStatement(modelToBeModified, subject.getURI(), property, objectNode.asResource().getURI());
        } else {
            action = new AddDataPropertyStatement(modelToBeModified, subject.getURI(), predicate.getURI(), objectNode.asLiteral().getString());
        }
        return PolicyHelper.isAuthorizedForActions(req, (AuthorizationRequest)action);
    }

    public static boolean isAuthorizedToDrop(HttpServletRequest req, Statement stmt, OntModel modelToBeModified) {
        AbstractPropertyStatementAction action;
        if (req == null || stmt == null || modelToBeModified == null) {
            return false;
        }
        Resource subject = stmt.getSubject();
        com.hp.hpl.jena.rdf.model.Property predicate = stmt.getPredicate();
        RDFNode objectNode = stmt.getObject();
        if (subject == null || predicate == null || objectNode == null) {
            return false;
        }
        if (objectNode.isResource()) {
            Property property = new Property(predicate.getURI());
            property.setDomainVClassURI(RequestedAction.SOME_URI);
            property.setRangeVClassURI(RequestedAction.SOME_URI);
            action = new DropObjectPropertyStatement(modelToBeModified, subject.getURI(), property, objectNode.asResource().getURI());
        } else {
            action = new DropDataPropertyStatement(modelToBeModified, subject.getURI(), predicate.getURI(), objectNode.asLiteral().getString());
        }
        return PolicyHelper.isAuthorizedForActions(req, (AuthorizationRequest)action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAuthorizedAsExpected(HttpServletRequest req, Model additions, Model retractions, OntModel modelBeingModified) {
        if (req == null) {
            log.warn((Object)"Can't evaluate authorization if req is null");
            return false;
        }
        if (additions == null) {
            log.warn((Object)"Can't evaluate authorization if additions model is null");
            return false;
        }
        if (retractions == null) {
            log.warn((Object)"Can't evaluate authorization if retractions model is null");
            return false;
        }
        if (modelBeingModified == null) {
            log.warn((Object)"Can't evaluate authorization if model being modified is null");
            return false;
        }
        boolean result = true;
        OntModel modelToTestAgainst = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        modelToTestAgainst.addSubModel(additions);
        modelToTestAgainst.addSubModel((Model)modelBeingModified);
        try (StmtIterator addStmts = additions.listStatements();){
            while (addStmts.hasNext()) {
                Statement stmt = (Statement)addStmts.next();
                if (PolicyHelper.isAuthorizedToAdd(req, stmt, modelToTestAgainst)) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Last-chance authorization check: authorized to add statement: " + PolicyHelper.formatStatement(stmt)));
                    continue;
                }
                log.warn((Object)("Last-chance authorization check reveals not authorized to add statement: " + PolicyHelper.formatStatement(stmt)));
                result = false;
            }
        }
        try (StmtIterator dropStmts = retractions.listStatements();){
            while (dropStmts.hasNext()) {
                Statement stmt = (Statement)dropStmts.next();
                if (PolicyHelper.isAuthorizedToDrop(req, stmt, modelToTestAgainst)) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Last-chance authorization check: authorized to drop statement: " + PolicyHelper.formatStatement(stmt)));
                    continue;
                }
                log.warn((Object)("Last-chance authorization check reveals not authorized to drop statement: " + PolicyHelper.formatStatement(stmt)));
                result = false;
            }
        }
        return result;
    }

    private static String formatStatement(Statement stmt) {
        if (stmt == null) {
            return "null statement";
        }
        return "<" + stmt.getSubject() + "> <" + stmt.getPredicate() + "> <" + stmt.getObject() + ">";
    }

    private PolicyHelper() {
    }
}

