/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.policy.bean;

import edu.cornell.mannlib.vitro.webapp.auth.policy.bean.PropertyRestrictionBeanImpl;
import edu.cornell.mannlib.vitro.webapp.auth.policy.bean.PropertyRestrictionLevels;
import edu.cornell.mannlib.vitro.webapp.beans.BaseResourceBean;
import edu.cornell.mannlib.vitro.webapp.beans.Property;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.startup.StartupStatus;
import java.util.Arrays;
import java.util.Collection;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class PropertyRestrictionBean {
    private static final Log log = LogFactory.getLog(PropertyRestrictionBean.class);
    private static final PropertyRestrictionBean NULL;
    protected static volatile PropertyRestrictionBean instance;
    protected static final Collection<String> PROHIBITED_NAMESPACES;
    protected static final Collection<String> PERMITTED_EXCEPTIONS;

    public static PropertyRestrictionBean getBean() {
        return instance;
    }

    public abstract boolean canDisplayResource(String var1, BaseResourceBean.RoleLevel var2);

    public abstract boolean canModifyResource(String var1, BaseResourceBean.RoleLevel var2);

    public abstract boolean canPublishResource(String var1, BaseResourceBean.RoleLevel var2);

    public abstract boolean canDisplayPredicate(Property var1, BaseResourceBean.RoleLevel var2);

    public abstract boolean canModifyPredicate(Property var1, BaseResourceBean.RoleLevel var2);

    public abstract boolean canPublishPredicate(Property var1, BaseResourceBean.RoleLevel var2);

    public abstract void updateProperty(PropertyRestrictionLevels var1);

    static {
        instance = NULL = new PropertyRestrictionBeanNull();
        PROHIBITED_NAMESPACES = Arrays.asList("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#", "");
        PERMITTED_EXCEPTIONS = Arrays.asList("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#moniker", "http://vitro.mannlib.cornell.edu/ns/vitro/0.7#modTime", "http://vitro.mannlib.cornell.edu/ns/vitro/public#mainImage", "http://vitro.mannlib.cornell.edu/ns/vitro/0.7#Link", "http://vitro.mannlib.cornell.edu/ns/vitro/0.7#primaryLink", "http://vitro.mannlib.cornell.edu/ns/vitro/0.7#additionalLink", "http://vitro.mannlib.cornell.edu/ns/vitro/0.7#linkAnchor", "http://vitro.mannlib.cornell.edu/ns/vitro/0.7#linkURL");
    }

    public static class Setup
    implements ServletContextListener {
        public void contextInitialized(ServletContextEvent sce) {
            ServletContext ctx = sce.getServletContext();
            StartupStatus ss = StartupStatus.getBean(ctx);
            try {
                instance = new PropertyRestrictionBeanImpl(PROHIBITED_NAMESPACES, PERMITTED_EXCEPTIONS, ModelAccess.on(ctx));
            }
            catch (Exception e) {
                ss.fatal(this, "could not set up PropertyRestrictionBean", e);
            }
        }

        public void contextDestroyed(ServletContextEvent sce) {
            instance = NULL;
        }
    }

    private static class PropertyRestrictionBeanNull
    extends PropertyRestrictionBean {
        private PropertyRestrictionBeanNull() {
        }

        @Override
        public boolean canDisplayResource(String resourceUri, BaseResourceBean.RoleLevel userRole) {
            this.warn();
            return false;
        }

        @Override
        public boolean canModifyResource(String resourceUri, BaseResourceBean.RoleLevel userRole) {
            this.warn();
            return false;
        }

        @Override
        public boolean canPublishResource(String resourceUri, BaseResourceBean.RoleLevel userRole) {
            this.warn();
            return false;
        }

        @Override
        public boolean canDisplayPredicate(Property predicate, BaseResourceBean.RoleLevel userRole) {
            this.warn();
            return false;
        }

        @Override
        public boolean canModifyPredicate(Property predicate, BaseResourceBean.RoleLevel userRole) {
            this.warn();
            return false;
        }

        @Override
        public boolean canPublishPredicate(Property predicate, BaseResourceBean.RoleLevel userRole) {
            this.warn();
            return false;
        }

        @Override
        public void updateProperty(PropertyRestrictionLevels levels) {
            this.warn();
        }

        private void warn() {
            try {
                throw new IllegalStateException();
            }
            catch (IllegalStateException e) {
                log.warn((Object)"No PropertyRestrictionBean in place.", (Throwable)e);
                return;
            }
        }
    }
}

