/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.policy.specialrelationships;

import edu.cornell.mannlib.vitro.webapp.auth.policy.BasicPolicyDecision;
import edu.cornell.mannlib.vitro.webapp.auth.policy.bean.PropertyRestrictionBean;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.Authorization;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.PolicyDecision;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.PolicyIface;
import edu.cornell.mannlib.vitro.webapp.beans.BaseResourceBean;
import edu.cornell.mannlib.vitro.webapp.beans.Property;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractRelationshipPolicy
implements PolicyIface {
    private static final Log log = LogFactory.getLog(AbstractRelationshipPolicy.class);
    protected final ServletContext ctx;

    public AbstractRelationshipPolicy(ServletContext ctx) {
        this.ctx = ctx;
    }

    protected boolean canModifyResource(String uri) {
        return PropertyRestrictionBean.getBean().canModifyResource(uri, BaseResourceBean.RoleLevel.SELF);
    }

    protected boolean canModifyPredicate(Property predicate) {
        return PropertyRestrictionBean.getBean().canModifyPredicate(predicate, BaseResourceBean.RoleLevel.SELF);
    }

    protected PolicyDecision cantModifyResource(String uri) {
        return this.inconclusiveDecision("No access to admin resources; cannot modify " + uri);
    }

    protected PolicyDecision cantModifyPredicate(String uri) {
        return this.inconclusiveDecision("No access to admin predicates; cannot modify " + uri);
    }

    protected PolicyDecision userNotAuthorizedToStatement() {
        return this.inconclusiveDecision("User has no access to this statement.");
    }

    protected PolicyDecision inconclusiveDecision(String message) {
        return new BasicPolicyDecision(Authorization.INCONCLUSIVE, this.getClass().getSimpleName() + ": " + message);
    }
}

