/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.beans;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ApplicationBean {
    private static final Log log = LogFactory.getLog(ApplicationBean.class);
    public static final int CALS_SEARCHBOX_SIZE = 25;
    public static final int VIVO_SEARCHBOX_SIZE = 20;
    private static final String DEFAULT_APPLICATION_NAME = "Vitro";
    private static final String DEFAULT_ROOT_LOGOTYPE_IMAGE = "";
    private static final int DEFAULT_ROOT_LOGOTYPE_WIDTH = 0;
    private static final int DEFAULT_ROOT_LOGOTYPE_HEIGHT = 0;
    private static final String DEFAULT_ROOT_LOGOTYPE_TITLE = "";
    public static ThemeInfo themeInfo = new ThemeInfo(null, "no_default_theme", new ArrayList<String>());
    private boolean initialized = false;
    private String sessionIdStr = null;
    private String applicationName = "Vitro";
    private String rootLogotypeImage = "";
    private int rootLogotypeWidth = 0;
    private int rootLogotypeHeight = 0;
    private String rootLogotypeTitle = "";
    private String aboutText;
    private String acknowledgeText;
    private String contactMail;
    private String correctionMail;
    private String copyrightURL;
    private String copyrightAnchor;
    private String themeDir;

    public String toString() {
        String output = "Application Bean Contents:\n";
        output = output + "  initialized from DB:    [" + this.initialized + "]\n";
        output = output + "  session id:             [" + this.sessionIdStr + "]\n";
        output = output + "  application name:       [" + this.applicationName + "]\n";
        output = output + "  root logotype image:    [" + this.rootLogotypeImage + "]\n";
        output = output + "  root logotype width:    [" + this.rootLogotypeWidth + "]\n";
        output = output + "  root logotype height:   [" + this.rootLogotypeHeight + "]\n";
        output = output + "  root logotype title:    [" + this.rootLogotypeTitle + "]\n";
        return output;
    }

    public void setSessionIdStr(String string_val) {
        this.sessionIdStr = string_val;
    }

    public void setApplicationName(String string_val) {
        this.applicationName = string_val;
    }

    public void setRootLogotypeImage(String string_val) {
        this.rootLogotypeImage = string_val;
    }

    public void setRootLogotypeWidth(int int_val) {
        this.rootLogotypeWidth = int_val;
    }

    public void setRootLogotypeHeight(int int_val) {
        this.rootLogotypeHeight = int_val;
    }

    public void setRootLogotypeTitle(String string_val) {
        this.rootLogotypeTitle = string_val;
    }

    public void setAboutText(String string_val) {
        this.aboutText = string_val;
    }

    public void setAcknowledgeText(String string_val) {
        this.acknowledgeText = string_val;
    }

    public void setContactMail(String string_val) {
        this.contactMail = string_val;
    }

    public void setCorrectionMail(String string_val) {
        this.correctionMail = string_val;
    }

    public void setCopyrightURL(String string_val) {
        this.copyrightURL = string_val;
    }

    public void setCopyrightAnchor(String string_val) {
        this.copyrightAnchor = string_val;
    }

    public void setThemeDir(String string_val) {
        this.themeDir = string_val;
    }

    public String getSessionIdStr() {
        return this.sessionIdStr;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getRootLogotypeImage() {
        return this.rootLogotypeImage;
    }

    public int getRootLogotypeWidth() {
        return this.rootLogotypeWidth;
    }

    public int getRootLogotypeHeight() {
        return this.rootLogotypeHeight;
    }

    public String getRootLogotypeTitle() {
        return this.rootLogotypeTitle;
    }

    public String getAboutText() {
        return this.aboutText;
    }

    public String getAcknowledgeText() {
        return this.acknowledgeText;
    }

    public String getContactMail() {
        return this.contactMail;
    }

    public String getCorrectionMail() {
        return this.correctionMail;
    }

    public String getCopyrightURL() {
        return this.copyrightURL;
    }

    public String getCopyrightAnchor() {
        return this.copyrightAnchor;
    }

    public String getRootBreadCrumbURL() {
        return "";
    }

    public String getRootBreadCrumbAnchor() {
        return "";
    }

    public String getShortHand() {
        return "";
    }

    public String getThemeDir() {
        if (themeInfo.isValidThemeDir(this.themeDir)) {
            return this.themeDir;
        }
        return themeInfo.getDefaultThemeDir();
    }

    public static class ThemeInfo {
        private final File themesBaseDir;
        private final String defaultThemeName;
        private final List<String> themeNames;

        public ThemeInfo(File themesBaseDir, String defaultThemeName, List<String> themeNames) {
            this.themesBaseDir = themesBaseDir;
            this.defaultThemeName = defaultThemeName;
            this.themeNames = Collections.unmodifiableList(new ArrayList<String>(themeNames));
        }

        public static String themeNameFromDir(String themeDir) {
            if (themeDir == null) {
                return themeDir;
            }
            if (!themeDir.startsWith("themes/") || !themeDir.endsWith("/")) {
                return themeDir;
            }
            return themeDir.substring(7, themeDir.length() - 1);
        }

        public boolean isValidThemeDir(String themeDir) {
            if (themeDir == null) {
                return false;
            }
            return this.themeNames.contains(ThemeInfo.themeNameFromDir(themeDir));
        }

        public String getDefaultThemeDir() {
            return "themes/" + this.defaultThemeName + "/";
        }

        public File getThemesBaseDir() {
            return this.themesBaseDir;
        }

        public String getDefaultThemeName() {
            return this.defaultThemeName;
        }

        public List<String> getThemeNames() {
            return this.themeNames;
        }
    }
}

