/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.beans;

import edu.cornell.mannlib.vitro.webapp.beans.BaseResourceBean;
import edu.cornell.mannlib.vitro.webapp.beans.DataProperty;
import edu.cornell.mannlib.vitro.webapp.beans.DataPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.filestorage.model.ImageInfo;
import java.sql.Timestamp;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class IndividualImpl
extends BaseResourceBean
implements Individual,
Comparable<Individual> {
    protected static final String NOT_INITIALIZED = "__%NOT_INITIALIZED%__";
    public String name = null;
    protected String rdfsLabel = null;
    public String vClassURI = null;
    protected VClass vClass = null;
    protected List<VClass> directVClasses = null;
    protected List<VClass> allVClasses = null;
    protected Timestamp modTime = null;
    protected List<ObjectProperty> propertyList = null;
    protected List<ObjectProperty> populatedObjectPropertyList = null;
    protected Map<String, ObjectProperty> objectPropertyMap = null;
    protected List<DataProperty> datatypePropertyList = null;
    protected List<DataProperty> populatedDataPropertyList = null;
    protected Map<String, DataProperty> dataPropertyMap = null;
    protected List<DataPropertyStatement> dataPropertyStatements = null;
    protected List<ObjectPropertyStatement> objectPropertyStatements = null;
    protected List<ObjectPropertyStatement> rangeEnts2Ents = null;
    protected List<DataPropertyStatement> externalIds = null;
    protected String mainImageUri = "__%NOT_INITIALIZED%__";
    protected ImageInfo imageInfo = null;
    protected Float searchBoost;
    protected String searchSnippet;
    protected boolean sorted = false;
    protected boolean DIRECT = true;
    protected boolean ALL = false;
    public static final String[] INCLUDED_IN_JSON = new String[]{"URI", "name", "vClassId"};

    public IndividualImpl() {
    }

    public IndividualImpl(String URI2) {
        this.setURI(URI2);
        this.setVClasses(new ArrayList<VClass>(), this.DIRECT);
        this.setVClasses(new ArrayList<VClass>(), this.ALL);
        this.setObjectPropertyStatements(new ArrayList<ObjectPropertyStatement>());
        this.setObjectPropertyMap(new HashMap<String, ObjectProperty>());
        this.setDataPropertyStatements(new ArrayList<DataPropertyStatement>());
        this.setDataPropertyMap(new HashMap<String, DataProperty>());
        this.setPropertyList(new ArrayList<ObjectProperty>());
        this.setDatatypePropertyList(new ArrayList<DataProperty>());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String in) {
        this.name = in;
    }

    @Override
    public String getRdfsLabel() {
        return this.rdfsLabel;
    }

    @Override
    public void setRdfsLabel(String s) {
        this.rdfsLabel = s;
    }

    @Override
    public String getVClassURI() {
        return this.vClassURI;
    }

    @Override
    public void setVClassURI(String in) {
        this.vClassURI = in;
    }

    @Override
    public Timestamp getModTime() {
        return this.modTime;
    }

    @Override
    public void setModTime(Timestamp in) {
        this.modTime = in;
    }

    @Override
    public List<ObjectProperty> getObjectPropertyList() {
        return this.propertyList;
    }

    @Override
    public void setPropertyList(List<ObjectProperty> propertyList) {
        this.propertyList = propertyList;
    }

    @Override
    public List<ObjectProperty> getPopulatedObjectPropertyList() {
        return this.populatedObjectPropertyList;
    }

    @Override
    public void setPopulatedObjectPropertyList(List<ObjectProperty> propertyList) {
        this.populatedObjectPropertyList = propertyList;
    }

    @Override
    public Map<String, ObjectProperty> getObjectPropertyMap() {
        return this.objectPropertyMap;
    }

    @Override
    public void setObjectPropertyMap(Map<String, ObjectProperty> propertyMap) {
        this.objectPropertyMap = propertyMap;
    }

    @Override
    public List<DataProperty> getDataPropertyList() {
        return this.datatypePropertyList;
    }

    @Override
    public void setDatatypePropertyList(List<DataProperty> datatypePropertyList) {
        this.datatypePropertyList = datatypePropertyList;
    }

    @Override
    public List<DataProperty> getPopulatedDataPropertyList() {
        return this.populatedDataPropertyList;
    }

    @Override
    public void setPopulatedDataPropertyList(List<DataProperty> propertyList) {
        this.populatedDataPropertyList = propertyList;
    }

    @Override
    public Map<String, DataProperty> getDataPropertyMap() {
        return this.dataPropertyMap;
    }

    @Override
    public void setDataPropertyMap(Map<String, DataProperty> propertyMap) {
        this.dataPropertyMap = propertyMap;
    }

    @Override
    public void setDataPropertyStatements(List<DataPropertyStatement> list) {
        this.dataPropertyStatements = list;
    }

    @Override
    public List<DataPropertyStatement> getDataPropertyStatements() {
        return this.dataPropertyStatements;
    }

    @Override
    public List<DataPropertyStatement> getDataPropertyStatements(String propertyUri) {
        List<DataPropertyStatement> stmts = this.getDataPropertyStatements();
        ArrayList<DataPropertyStatement> stmtsForProp = new ArrayList<DataPropertyStatement>();
        for (DataPropertyStatement stmt : stmts) {
            if (!stmt.getDatapropURI().equals(propertyUri)) continue;
            stmtsForProp.add(stmt);
        }
        return stmtsForProp;
    }

    @Override
    public DataPropertyStatement getDataPropertyStatement(String propertyUri) {
        List<DataPropertyStatement> stmts = this.getDataPropertyStatements(propertyUri);
        return stmts.isEmpty() ? null : stmts.get(0);
    }

    @Override
    public List<String> getDataValues(String propertyUri) {
        List<DataPropertyStatement> stmts = this.getDataPropertyStatements(propertyUri);
        ArrayList<String> dataValues = new ArrayList<String>(stmts.size());
        for (DataPropertyStatement stmt : stmts) {
            dataValues.add(stmt.getData());
        }
        return dataValues;
    }

    @Override
    public String getDataValue(String propertyUri) {
        List<DataPropertyStatement> stmts = this.getDataPropertyStatements(propertyUri);
        return stmts.isEmpty() ? null : stmts.get(0).getData();
    }

    @Override
    public VClass getVClass() {
        return this.vClass;
    }

    @Override
    public void setVClass(VClass class1) {
        this.vClass = class1;
    }

    @Override
    public List<VClass> getVClasses() {
        return this.allVClasses;
    }

    @Override
    public boolean isVClass(String uri) {
        if (uri == null) {
            return false;
        }
        for (VClass vClass : this.getVClasses()) {
            if (!uri.equals(vClass.getURI())) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<VClass> getVClasses(boolean direct) {
        if (direct) {
            return this.directVClasses;
        }
        return this.allVClasses;
    }

    @Override
    public void setVClasses(List<VClass> vClassList, boolean direct) {
        if (direct) {
            this.directVClasses = vClassList;
        } else {
            this.allVClasses = vClassList;
        }
    }

    @Override
    public List<String> getMostSpecificTypeURIs() {
        ArrayList<String> typeURIs = new ArrayList<String>();
        List<ObjectPropertyStatement> stmts = this.getObjectPropertyStatements("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#mostSpecificType");
        for (ObjectPropertyStatement stmt : stmts) {
            String objURI = stmt.getObjectURI();
            if (objURI == null) continue;
            typeURIs.add(objURI);
        }
        return typeURIs;
    }

    @Override
    public void setObjectPropertyStatements(List<ObjectPropertyStatement> list) {
        this.objectPropertyStatements = list;
    }

    @Override
    public List<ObjectPropertyStatement> getObjectPropertyStatements() {
        return this.objectPropertyStatements;
    }

    @Override
    public List<ObjectPropertyStatement> getObjectPropertyStatements(String propertyUri) {
        List<ObjectPropertyStatement> stmts = this.getObjectPropertyStatements();
        ArrayList<ObjectPropertyStatement> stmtsForProp = new ArrayList<ObjectPropertyStatement>();
        for (ObjectPropertyStatement stmt : stmts) {
            if (!stmt.getPropertyURI().equals(propertyUri)) continue;
            stmtsForProp.add(stmt);
        }
        return stmtsForProp;
    }

    @Override
    public List<Individual> getRelatedIndividuals(String propertyUri) {
        List<ObjectPropertyStatement> stmts = this.getObjectPropertyStatements(propertyUri);
        ArrayList<Individual> relatedIndividuals = new ArrayList<Individual>(stmts.size());
        for (ObjectPropertyStatement stmt : stmts) {
            relatedIndividuals.add(stmt.getObject());
        }
        return relatedIndividuals;
    }

    @Override
    public Individual getRelatedIndividual(String propertyUri) {
        List<ObjectPropertyStatement> stmts = this.getObjectPropertyStatements(propertyUri);
        return stmts.isEmpty() ? null : stmts.get(0).getObject();
    }

    @Override
    public List<DataPropertyStatement> getExternalIds() {
        return this.externalIds;
    }

    @Override
    public void setExternalIds(List<DataPropertyStatement> externalIds) {
        this.externalIds = externalIds;
    }

    @Override
    public String getMainImageUri() {
        return this.mainImageUri == NOT_INITIALIZED ? null : this.mainImageUri;
    }

    @Override
    public void setMainImageUri(String mainImageUri) {
        this.mainImageUri = mainImageUri;
        this.imageInfo = null;
    }

    @Override
    public String getImageUrl() {
        return "imageUrl";
    }

    @Override
    public String getThumbUrl() {
        return "thumbUrl";
    }

    @Override
    public Float getSearchBoost() {
        return this.searchBoost;
    }

    @Override
    public void setSearchBoost(Float boost) {
        this.searchBoost = boost;
    }

    @Override
    public String getSearchSnippet() {
        return this.searchSnippet;
    }

    @Override
    public void setSearchSnippet(String snippet) {
        this.searchSnippet = snippet;
    }

    @Override
    public void sortForDisplay() {
        if (this.sorted) {
            return;
        }
        if (this.getObjectPropertyList() == null) {
            return;
        }
        this.sortPropertiesForDisplay();
        this.sortEnts2EntsForDisplay();
        this.sorted = true;
    }

    protected void sortEnts2EntsForDisplay() {
        if (this.getObjectPropertyList() == null) {
            return;
        }
        for (ObjectProperty prop : this.getObjectPropertyList()) {
            ObjectProperty.sortObjectPropertyStatementsForDisplay(prop, prop.getObjectPropertyStatements());
        }
    }

    protected void sortPropertiesForDisplay() {
        Collections.sort(this.getObjectPropertyList(), new ObjectProperty.DisplayComparator());
    }

    @Override
    public JSONObject toJSON() throws JSONException {
        JSONObject jsonObj = new JSONObject(this, INCLUDED_IN_JSON);
        return jsonObj;
    }

    @Override
    public int compareTo(Individual o2) {
        Collator collator = Collator.getInstance();
        if (o2 == null) {
            return 1;
        }
        return collator.compare(this.getName(), o2.getName());
    }

    public String toString() {
        if (this.getURI() == null) {
            return "uninitialized, null URI";
        }
        return this.getURI() + " " + this.getName();
    }

    @Override
    public boolean hasThumb() {
        return this.getThumbUrl() != null && !this.getThumbUrl().isEmpty();
    }

    @Override
    public void resolveAsFauxPropertyStatements(List<ObjectPropertyStatement> list) {
    }
}

