/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.config;

import edu.cornell.mannlib.vitro.webapp.config.DummyConfigurationProperties;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ConfigurationProperties {
    private static final Log log = LogFactory.getLog(ConfigurationProperties.class);
    private static final String ATTRIBUTE_NAME = ConfigurationProperties.class.getName();
    private static final ConfigurationProperties DUMMY_PROPERTIES = new DummyConfigurationProperties();

    public static ConfigurationProperties getBean(ServletRequest request) {
        if (request == null) {
            throw new NullPointerException("request may not be null.");
        }
        if (!(request instanceof HttpServletRequest)) {
            throw new IllegalArgumentException("request must be an HttpServletRequest");
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        return ConfigurationProperties.getBean(httpRequest.getSession());
    }

    public static ConfigurationProperties getBean(HttpSession session) {
        if (session == null) {
            throw new NullPointerException("session may not be null.");
        }
        return ConfigurationProperties.getBean(session.getServletContext());
    }

    public static ConfigurationProperties getBean(HttpServlet servlet) {
        if (servlet == null) {
            throw new NullPointerException("servlet may not be null.");
        }
        return ConfigurationProperties.getBean(servlet.getServletContext());
    }

    public static ConfigurationProperties getBean(ServletContextEvent sce) {
        if (sce == null) {
            throw new NullPointerException("sce may not be null.");
        }
        return ConfigurationProperties.getBean(sce.getServletContext());
    }

    public static ConfigurationProperties getBean(ServletConfig servletConfig) {
        if (servletConfig == null) {
            throw new NullPointerException("servletConfig may not be null.");
        }
        return ConfigurationProperties.getBean(servletConfig.getServletContext());
    }

    public static ConfigurationProperties getBean(ServletContext context) {
        if (context == null) {
            throw new NullPointerException("context may not be null.");
        }
        Object o = context.getAttribute(ATTRIBUTE_NAME);
        if (o == null) {
            log.error((Object)"ConfigurationProperties bean has not been set.");
            return DUMMY_PROPERTIES;
        }
        if (!(o instanceof ConfigurationProperties)) {
            log.error((Object)("Error: ConfigurationProperties was set to an invalid object: " + o));
            return DUMMY_PROPERTIES;
        }
        return (ConfigurationProperties)o;
    }

    protected static void setBean(ServletContext context, ConfigurationProperties bean) {
        if (context == null) {
            throw new NullPointerException("context may not be null.");
        }
        if (bean == null) {
            throw new NullPointerException("bean may not be null.");
        }
        context.setAttribute(ATTRIBUTE_NAME, (Object)bean);
        log.info((Object)bean);
    }

    static void removeBean(ServletContext context) {
        if (context == null) {
            throw new NullPointerException("context may not be null.");
        }
        context.removeAttribute(ATTRIBUTE_NAME);
    }

    public abstract String getProperty(String var1);

    public abstract String getProperty(String var1, String var2);

    public abstract Map<String, String> getPropertyMap();
}

