/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.config;

import edu.cornell.mannlib.vitro.webapp.config.ConfigurationProperties;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigurationPropertiesImpl
extends ConfigurationProperties {
    private static final Log log = LogFactory.getLog(ConfigurationPropertiesImpl.class);
    private final Map<String, String> propertyMap;

    public ConfigurationPropertiesImpl(InputStream stream, Map<String, String> preemptiveProperties, Map<String, String> buildProperties) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>(buildProperties);
        Properties props = this.loadFromPropertiesFile(stream);
        for (String key : props.stringPropertyNames()) {
            map.put(key, props.getProperty(key));
        }
        if (preemptiveProperties != null) {
            map.putAll(preemptiveProperties);
        }
        this.trimWhiteSpaceFromValues(map);
        this.propertyMap = Collections.unmodifiableMap(map);
        log.debug((Object)("Configuration properties are: " + map));
    }

    private Properties loadFromPropertiesFile(InputStream stream) throws IOException {
        Properties props = new Properties();
        props.load(stream);
        return props;
    }

    private void trimWhiteSpaceFromValues(Map<String, String> map) {
        for (String key : map.keySet()) {
            map.put(key, map.get(key).trim());
        }
    }

    @Override
    public String getProperty(String key) {
        return this.propertyMap.get(key);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        if (this.propertyMap.containsKey(key)) {
            return this.propertyMap.get(key);
        }
        return defaultValue;
    }

    @Override
    public Map<String, String> getPropertyMap() {
        return new HashMap<String, String>(this.propertyMap);
    }

    public String toString() {
        return "ConfigurationPropertiesImpl[propertyMap=" + new TreeMap<String, String>(this.propertyMap) + "]";
    }
}

