/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.config;

import com.ibm.icu.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RevisionInfoBean {
    private static final Log log = LogFactory.getLog(RevisionInfoBean.class);
    static final RevisionInfoBean DUMMY_BEAN = new RevisionInfoBean(new Date(0L), Collections.singleton(LevelRevisionInfo.DUMMY_LEVEL));
    static final String ATTRIBUTE_NAME = RevisionInfoBean.class.getName();
    private final long buildDate;
    private final List<LevelRevisionInfo> levelInfos;

    static void setBean(ServletContext context, RevisionInfoBean bean) {
        if (bean == null) {
            bean = DUMMY_BEAN;
        }
        context.setAttribute(ATTRIBUTE_NAME, (Object)bean);
        log.info((Object)bean);
    }

    public static RevisionInfoBean getBean(HttpSession session) {
        if (session == null) {
            log.warn((Object)"Tried to get revision info bean with a null session!");
            return DUMMY_BEAN;
        }
        return RevisionInfoBean.getBean(session.getServletContext());
    }

    public static RevisionInfoBean getBean(ServletContext context) {
        if (context == null) {
            log.warn((Object)"Tried to get revision info bean from a null context");
            return DUMMY_BEAN;
        }
        Object o = context.getAttribute(ATTRIBUTE_NAME);
        if (o == null) {
            log.warn((Object)"Tried to get revision info bean, but didn't find any.");
            return DUMMY_BEAN;
        }
        if (!(o instanceof RevisionInfoBean)) {
            log.error((Object)("Tried to get revision info bean, but found an instance of " + o.getClass().getName() + ": " + o));
            return DUMMY_BEAN;
        }
        return (RevisionInfoBean)o;
    }

    public static void removeBean(ServletContext context) {
        context.removeAttribute(ATTRIBUTE_NAME);
    }

    RevisionInfoBean(Date buildDate, Collection<LevelRevisionInfo> levelInfos) {
        this.buildDate = buildDate.getTime();
        this.levelInfos = Collections.unmodifiableList(new ArrayList<LevelRevisionInfo>(levelInfos));
    }

    public Date getBuildDate() {
        return new Date(this.buildDate);
    }

    public List<LevelRevisionInfo> getLevelInfos() {
        return this.levelInfos;
    }

    public String getReleaseLabel() {
        if (this.levelInfos.isEmpty()) {
            return LevelRevisionInfo.DUMMY_LEVEL.getRelease();
        }
        int lastIndex = this.levelInfos.size() - 1;
        LevelRevisionInfo outerLevel = this.levelInfos.get(lastIndex);
        return outerLevel.getRelease();
    }

    public String toString() {
        return "Revision info [build date: " + new SimpleDateFormat().format(new Date(this.buildDate)) + ", level info: " + this.levelInfos + "]";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RevisionInfoBean)) {
            return false;
        }
        RevisionInfoBean that = (RevisionInfoBean)obj;
        return this.buildDate == that.buildDate && this.levelInfos.equals(that.levelInfos);
    }

    public int hashCode() {
        return new Long(this.buildDate).hashCode() ^ this.levelInfos.hashCode();
    }

    public static class LevelRevisionInfo {
        static final LevelRevisionInfo DUMMY_LEVEL = new LevelRevisionInfo("no name", "unknown", "unknown");
        private final String name;
        private final String release;
        private final String revision;

        LevelRevisionInfo(String name, String release, String revision) {
            this.name = name;
            this.release = release;
            this.revision = revision;
        }

        public String getName() {
            return this.name;
        }

        public String getRelease() {
            return this.release;
        }

        public String getRevision() {
            return this.revision;
        }

        public String toString() {
            return "[" + this.name + ", " + this.release + ", " + this.revision + "]";
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof LevelRevisionInfo)) {
                return false;
            }
            LevelRevisionInfo that = (LevelRevisionInfo)obj;
            return this.name.equals(that.name) && this.release.equals(that.release) && this.revision.equals(that.revision);
        }

        public int hashCode() {
            return this.name.hashCode() ^ this.release.hashCode() ^ this.revision.hashCode();
        }
    }
}

