/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.config;

import edu.cornell.mannlib.vitro.webapp.config.RevisionInfoBean;
import edu.cornell.mannlib.vitro.webapp.startup.StartupStatus;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RevisionInfoSetup
implements ServletContextListener {
    private static final Log log = LogFactory.getLog(RevisionInfoSetup.class);
    private static final Pattern LEVEL_INFO_PATTERN = Pattern.compile("(.+) ~ (.+) ~ (.+)");
    static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    static final String RESOURCE_PATH = "/WEB-INF/resources/revisionInfo.txt";

    public void contextInitialized(ServletContextEvent sce) {
        RevisionInfoBean bean;
        ServletContext context = sce.getServletContext();
        try {
            List<String> lines = this.readRevisionInfo(context);
            bean = this.parseRevisionInformation(lines);
        }
        catch (Exception e) {
            StartupStatus.getBean(context).warning(this, "Failed to load the revision info", e);
            bean = RevisionInfoBean.DUMMY_BEAN;
        }
        RevisionInfoBean.setBean(sce.getServletContext(), bean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> readRevisionInfo(ServletContext context) throws IOException {
        BufferedReader reader = null;
        try {
            reader = this.openRevisionInfoReader(context);
            List<String> list = this.readSignificantLines(reader);
            return list;
        }
        finally {
            this.closeReader(reader);
        }
    }

    private BufferedReader openRevisionInfoReader(ServletContext context) throws FileNotFoundException {
        InputStream stream = context.getResourceAsStream(RESOURCE_PATH);
        if (stream == null) {
            throw new FileNotFoundException("Can't find a resource in the webapp at '/WEB-INF/resources/revisionInfo.txt'.");
        }
        return new BufferedReader(new InputStreamReader(stream));
    }

    private List<String> readSignificantLines(BufferedReader reader) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        String line = null;
        while (null != (line = reader.readLine())) {
            if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
            lines.add(line);
        }
        return lines;
    }

    private void closeReader(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private RevisionInfoBean parseRevisionInformation(List<String> lines) throws ParseException {
        this.checkValidNumberOfLines(lines);
        String dateLine = lines.get(0);
        List<String> levelLines = lines.subList(1, lines.size());
        Date buildDate = this.parseDateLine(dateLine);
        List<RevisionInfoBean.LevelRevisionInfo> levelInfos = this.parseLevelLines(levelLines);
        return new RevisionInfoBean(buildDate, levelInfos);
    }

    private void checkValidNumberOfLines(List<String> lines) throws ParseException {
        if (lines.isEmpty()) {
            throw new ParseException("The revision info resource file contains no data.", 0);
        }
    }

    private Date parseDateLine(String dateLine) throws ParseException {
        return new SimpleDateFormat(DATE_FORMAT).parse(dateLine);
    }

    private List<RevisionInfoBean.LevelRevisionInfo> parseLevelLines(List<String> levelLines) throws ParseException {
        ArrayList<RevisionInfoBean.LevelRevisionInfo> infos = new ArrayList<RevisionInfoBean.LevelRevisionInfo>();
        for (String line : levelLines) {
            Matcher m = LEVEL_INFO_PATTERN.matcher(line);
            if (m.matches()) {
                String name = m.group(1).trim();
                String release = m.group(2).trim();
                String revision = m.group(3).trim();
                infos.add(new RevisionInfoBean.LevelRevisionInfo(name, release, revision));
                continue;
            }
            throw new ParseException("Failed to parse the revision info in '" + line + "'", 0);
        }
        return infos;
    }

    public void contextDestroyed(ServletContextEvent sce) {
        RevisionInfoBean.removeBean(sce.getServletContext());
    }
}

