/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.sparql.resultset.ResultsFormat;
import edu.cornell.mannlib.vedit.controller.BaseEditController;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SparqlQueryBuilderServlet
extends BaseEditController {
    private static final Log log = LogFactory.getLog((String)SparqlQueryBuilderServlet.class.getName());
    protected static final Syntax SYNTAX = Syntax.syntaxARQ;
    protected static HashMap<String, ResultsFormat> formatSymbols = new HashMap();
    protected static HashMap<String, String> rdfFormatSymbols;
    protected static HashMap<String, String> mimeTypes;

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.isAuthorizedToDisplayPage(request, response, SimplePermission.USE_ADVANCED_DATA_TOOLS_PAGES.ACTION)) {
            return;
        }
        VitroRequest vreq = new VitroRequest(request);
        OntModel model = vreq.getJenaOntModel();
        if (model == null) {
            this.doNoModelInContext(request, response);
            return;
        }
        this.doHelp(request, response);
    }

    private void doNoModelInContext(HttpServletRequest request, HttpServletResponse res) {
        try {
            res.setStatus(501);
            ServletOutputStream sos = res.getOutputStream();
            sos.println("<html><body>this service is not supporeted by the current webapp configuration. A jena model is required in the servlet context.</body></html>");
        }
        catch (IOException e) {
            log.error((Object)"Could not write to ServletOutputStream");
        }
    }

    private void doHelp(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        req.setAttribute("title", (Object)"SPARQL Query Builder");
        req.setAttribute("bodyJsp", (Object)"/admin/sparql.jsp");
        RequestDispatcher rd = req.getRequestDispatcher("//templates/page/basicPage.jsp");
        rd.forward((ServletRequest)req, (ServletResponse)res);
    }

    static {
        formatSymbols.put(ResultsFormat.FMT_RS_XML.getSymbol(), ResultsFormat.FMT_RS_XML);
        formatSymbols.put(ResultsFormat.FMT_RDF_XML.getSymbol(), ResultsFormat.FMT_RDF_XML);
        formatSymbols.put(ResultsFormat.FMT_RDF_N3.getSymbol(), ResultsFormat.FMT_RDF_N3);
        formatSymbols.put(ResultsFormat.FMT_TEXT.getSymbol(), ResultsFormat.FMT_TEXT);
        formatSymbols.put(ResultsFormat.FMT_RS_JSON.getSymbol(), ResultsFormat.FMT_RS_JSON);
        formatSymbols.put("vitro:csv", null);
        rdfFormatSymbols = new HashMap();
        rdfFormatSymbols.put("RDF/XML", "application/rdf+xml");
        rdfFormatSymbols.put("RDF/XML-ABBREV", "application/rdf+xml");
        rdfFormatSymbols.put("N3", "text/n3");
        rdfFormatSymbols.put("N-TRIPLE", "text/plain");
        rdfFormatSymbols.put("TTL", "application/x-turtle");
        mimeTypes = new HashMap();
        mimeTypes.put(ResultsFormat.FMT_RS_XML.getSymbol(), "text/xml");
        mimeTypes.put(ResultsFormat.FMT_RDF_XML.getSymbol(), "application/rdf+xml");
        mimeTypes.put(ResultsFormat.FMT_RDF_N3.getSymbol(), "text/plain");
        mimeTypes.put(ResultsFormat.FMT_TEXT.getSymbol(), "text/plain");
        mimeTypes.put(ResultsFormat.FMT_RS_JSON.getSymbol(), "application/javascript");
        mimeTypes.put("vitro:csv", "text/csv");
    }
}

