/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.accounts;

public class UserAccountsOrdering {
    public static final UserAccountsOrdering DEFAULT_ORDERING = new UserAccountsOrdering(Field.DEFAULT_FIELD, Direction.DEFAULT_DIRECTION);
    private final Field field;
    private final Direction direction;

    public UserAccountsOrdering(Field field, Direction direction) {
        this.field = field;
        this.direction = direction;
    }

    public Field getField() {
        return this.field;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public String toString() {
        return "UserAccountsOrdering[field=" + (Object)((Object)this.field) + ", direction=" + (Object)((Object)this.direction) + "]";
    }

    public static enum Field {
        EMAIL("email"),
        FIRST_NAME("firstName"),
        LAST_NAME("lastName"),
        STATUS("status"),
        ROLE("ps"),
        LOGIN_COUNT("count"),
        LAST_LOGIN_TIME("lastLogin");

        public static Field DEFAULT_FIELD;
        public final String name;

        public static Field fromName(String name) {
            if (name == null) {
                return DEFAULT_FIELD;
            }
            for (Field f : Field.values()) {
                if (!f.name.equals(name)) continue;
                return f;
            }
            return DEFAULT_FIELD;
        }

        private Field(String name) {
            this.name = name;
        }

        static {
            DEFAULT_FIELD = EMAIL;
        }
    }

    public static enum Direction {
        ASCENDING("ASC"),
        DESCENDING("DESC");

        public static Direction DEFAULT_DIRECTION;
        public final String keyword;

        public static Direction fromKeyword(String keyword) {
            if (keyword == null) {
                return DEFAULT_DIRECTION;
            }
            for (Direction d : Direction.values()) {
                if (!d.keyword.equals(keyword)) continue;
                return d;
            }
            return DEFAULT_DIRECTION;
        }

        private Direction(String keyword) {
            this.keyword = keyword;
        }

        static {
            DEFAULT_DIRECTION = ASCENDING;
        }
    }
}

