/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.accounts.manageproxies;

import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.SelfEditingConfiguration;
import edu.cornell.mannlib.vitro.webapp.beans.UserAccount;
import edu.cornell.mannlib.vitro.webapp.controller.AbstractPageHandler;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.servlet.ServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ManageProxiesCreatePage
extends AbstractPageHandler {
    private static final Log log = LogFactory.getLog(ManageProxiesCreatePage.class);
    private static final String PARAMETER_PROXY_URI = "proxyUri";
    private static final String PARAMETER_PROFILE_URI = "profileUri";
    private final SelfEditingConfiguration selfEditingConfiguration;
    private List<String> proxyUris;
    private List<String> profileUris;
    private List<UserAccount> proxyAccounts;
    private boolean valid = true;

    public ManageProxiesCreatePage(VitroRequest vreq) {
        super(vreq);
        this.selfEditingConfiguration = SelfEditingConfiguration.getBean((ServletRequest)vreq);
        this.parseParameters();
    }

    private void parseParameters() {
        try {
            this.proxyUris = this.getStringParameters(PARAMETER_PROXY_URI);
            this.profileUris = this.getStringParameters(PARAMETER_PROFILE_URI);
            this.proxyAccounts = this.findProxyAccounts();
            this.validateProfileUris();
        }
        catch (AbstractPageHandler.InvalidParametersException e) {
            log.error((Object)e.getMessage());
            this.valid = false;
        }
    }

    private List<UserAccount> findProxyAccounts() throws AbstractPageHandler.InvalidParametersException {
        ArrayList<UserAccount> accounts = new ArrayList<UserAccount>();
        for (String proxyUri : this.proxyUris) {
            UserAccount proxy = this.userAccountsDao.getUserAccountByUri(proxyUri);
            if (proxy == null) {
                throw new AbstractPageHandler.InvalidParametersException("Found no User Account for proxyUri='" + proxyUri + "'");
            }
            accounts.add(proxy);
        }
        return accounts;
    }

    private void validateProfileUris() throws AbstractPageHandler.InvalidParametersException {
        for (String profileUri : this.profileUris) {
            Individual ind = this.indDao.getIndividualByURI(profileUri);
            if (ind != null) continue;
            throw new AbstractPageHandler.InvalidParametersException("Found no Individual for profileUri='" + profileUri + "'");
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public void createRelationships() {
        for (UserAccount proxyAccount : this.proxyAccounts) {
            HashSet<String> profiles = new HashSet<String>();
            profiles.addAll(this.figureNonSelfProfileUris(proxyAccount));
            profiles.addAll(proxyAccount.getProxiedIndividualUris());
            proxyAccount.setProxiedIndividualUris(profiles);
            this.userAccountsDao.updateUserAccount(proxyAccount);
        }
    }

    private Collection<String> figureNonSelfProfileUris(UserAccount proxyAccount) {
        ArrayList<String> myProfiles = new ArrayList<String>(this.profileUris);
        for (Individual self : this.selfEditingConfiguration.getAssociatedIndividuals(this.indDao, proxyAccount)) {
            myProfiles.remove(self.getURI());
        }
        return myProfiles;
    }
}

