/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.accounts.manageproxies;

import edu.cornell.mannlib.vitro.webapp.controller.accounts.manageproxies.ProxyItemInfo;
import edu.cornell.mannlib.vitro.webapp.controller.accounts.manageproxies.ProxyRelationship;
import edu.cornell.mannlib.vitro.webapp.controller.accounts.manageproxies.ProxyRelationshipSelection;
import edu.cornell.mannlib.vitro.webapp.controller.accounts.manageproxies.ProxyRelationshipSelectionCriteria;
import java.util.ArrayList;
import java.util.List;

public class ProxyRelationshipSelectionBuilder {
    final ProxyRelationshipSelectionCriteria criteria;
    final List<Relationship> relationships = new ArrayList<Relationship>();
    int count;

    public ProxyRelationshipSelectionBuilder(ProxyRelationshipSelectionCriteria criteria) {
        this.criteria = criteria;
    }

    public ProxyRelationshipSelection build() {
        ArrayList<ProxyRelationship> proxyRelationships = new ArrayList<ProxyRelationship>();
        for (Relationship r : this.relationships) {
            proxyRelationships.add(this.buildProxyRelationship(r));
        }
        return new ProxyRelationshipSelection(this.criteria, proxyRelationships, this.count);
    }

    private ProxyRelationship buildProxyRelationship(Relationship r) {
        List<ProxyItemInfo> proxyInfos = this.buildInfos(r.proxyInfos);
        List<ProxyItemInfo> profileInfos = this.buildInfos(r.profileInfos);
        return new ProxyRelationship(proxyInfos, profileInfos);
    }

    private List<ProxyItemInfo> buildInfos(List<ItemInfo> infos) {
        ArrayList<ProxyItemInfo> result = new ArrayList<ProxyItemInfo>();
        for (ItemInfo info : infos) {
            result.add(new ProxyItemInfo(info.uri, info.label, info.classLabel, info.imageUrl));
        }
        return result;
    }

    public static class ItemInfo {
        String uri = "";
        String label = "";
        String externalAuthId = "";
        String classLabel = "";
        String imageUrl = "";

        public ItemInfo() {
        }

        public ItemInfo(String uri, String label, String externalAuthId, String classLabel, String imageUrl) {
            this.uri = uri;
            this.label = label;
            this.externalAuthId = externalAuthId;
            this.classLabel = classLabel;
            this.imageUrl = imageUrl;
        }
    }

    public static class Relationship {
        final List<ItemInfo> proxyInfos = new ArrayList<ItemInfo>();
        final List<ItemInfo> profileInfos = new ArrayList<ItemInfo>();
    }
}

