/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.accounts.manageproxies.ajax;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.rdf.model.Model;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.ajax.AbstractAjaxResponder;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.utils.SparqlQueryRunner;
import edu.cornell.mannlib.vitro.webapp.utils.SparqlQueryUtils;
import edu.cornell.mannlib.vitro.webapp.web.images.PlaceholderUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;

public class BasicProxiesGetter
extends AbstractAjaxResponder {
    private static final Log log = LogFactory.getLog(BasicProxiesGetter.class);
    private static final String PARAMETER_SEARCH_TERM = "term";
    private static final String QUERY_BASIC_PROXIES = "PREFIX fn: <http://www.w3.org/2005/xpath-functions#> \nPREFIX auth: <http://vitro.mannlib.cornell.edu/ns/vitro/authorization#> \n\nSELECT DISTINCT ?uri ?label \nWHERE { \n    ?uri a auth:UserAccount ; \n            auth:firstName ?firstName ; \n            auth:lastName ?lastName . \n    LET ( ?label := fn:concat(?lastName, ', ', ?firstName) )    FILTER (REGEX(?label, '^%term%', 'i')) \n} \nORDER BY ASC(?lastName) ASC(?firstName) \nLIMIT 25 \n";
    private final String term = this.getStringParameter("term", "");
    private final OntModel userAccountsModel;
    private final String placeholderImageUrl;

    public BasicProxiesGetter(HttpServlet servlet, VitroRequest vreq, HttpServletResponse resp) {
        super(servlet, vreq, resp);
        this.userAccountsModel = ModelAccess.on((HttpServletRequest)vreq).getOntModel("http://vitro.mannlib.cornell.edu/default/vitro-kb-userAccounts", new ModelAccess.LanguageOption[0]);
        this.placeholderImageUrl = UrlBuilder.getUrl(PlaceholderUtil.getPlaceholderImagePathForType(vreq, "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#UserAccount"));
    }

    @Override
    public String prepareResponse() throws IOException, JSONException {
        log.debug((Object)("search term is '" + this.term + "'"));
        if (this.term.isEmpty()) {
            return "[]";
        }
        String cleanTerm = SparqlQueryUtils.escapeForRegex(this.term);
        String queryStr = QUERY_BASIC_PROXIES.replace("%term%", cleanTerm);
        JSONArray jsonArray = new SparqlQueryRunner((Model)this.userAccountsModel).executeSelect(new BasicProxyInfoParser(this.placeholderImageUrl), queryStr);
        String response = jsonArray.toString();
        log.debug((Object)response);
        return response;
    }

    private static class BasicProxyInfoParser
    extends AbstractAjaxResponder.JsonArrayParser {
        private final String placeholderImageUrl;

        public BasicProxyInfoParser(String placeholderImageUrl) {
            this.placeholderImageUrl = placeholderImageUrl;
        }

        @Override
        protected Map<String, String> parseSolutionRow(QuerySolution solution) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("uri", solution.getResource("uri").getURI());
            map.put("label", this.ifLiteralPresent(solution, "label", ""));
            map.put("classLabel", "");
            map.put("imageUrl", this.placeholderImageUrl);
            return map;
        }
    }
}

