/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.accounts.user;

import edu.cornell.mannlib.vitro.webapp.beans.UserAccount;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.accounts.UserAccountsPage;
import edu.cornell.mannlib.vitro.webapp.controller.accounts.user.UserAccountsMyAccountPage;
import edu.cornell.mannlib.vitro.webapp.controller.authenticate.Authenticator;
import edu.cornell.mannlib.vitro.webapp.email.FreemarkerEmailFactory;
import edu.cornell.mannlib.vitro.webapp.email.FreemarkerEmailMessage;
import java.util.HashMap;
import java.util.Map;
import javax.mail.Message;

public abstract class UserAccountsMyAccountPageStrategy
extends UserAccountsPage {
    private static final String CONFIRM_CHANGE = "confirmChange";
    private static final String CONFIRM_EMAIL_SENT = "confirmEmailSent";
    protected final UserAccountsMyAccountPage page;

    public static UserAccountsMyAccountPageStrategy getInstance(VitroRequest vreq, UserAccountsMyAccountPage page, boolean externalAuth) {
        if (externalAuth) {
            return new ExternalAuthStrategy(vreq, page);
        }
        return new InternalAuthStrategy(vreq, page);
    }

    protected UserAccountsMyAccountPageStrategy(VitroRequest vreq, UserAccountsMyAccountPage page) {
        super(vreq);
        this.page = page;
    }

    public abstract void parseAdditionalParameters();

    public abstract String additionalValidations();

    public abstract void addMoreBodyValues(Map<String, Object> var1);

    public abstract void setAdditionalProperties(UserAccount var1);

    public abstract void notifyUser();

    public abstract String getConfirmationCode();

    private static class InternalAuthStrategy
    extends UserAccountsMyAccountPageStrategy {
        private static final String PARAMETER_NEW_PASSWORD = "newPassword";
        private static final String PARAMETER_CONFIRM_PASSWORD = "confirmPassword";
        private static final String ERROR_WRONG_PASSWORD_LENGTH = "errorPasswordIsWrongLength";
        private static final String ERROR_PASSWORDS_DONT_MATCH = "errorPasswordsDontMatch";
        private static final String EMAIL_TEMPLATE = "userAccounts-confirmEmailChangedEmail.ftl";
        private final String originalEmail;
        private String newPassword;
        private String confirmPassword;
        private boolean emailSent;

        InternalAuthStrategy(VitroRequest vreq, UserAccountsMyAccountPage page) {
            super(vreq, page);
            this.originalEmail = page.getUserAccount().getEmailAddress();
        }

        @Override
        public void parseAdditionalParameters() {
            this.newPassword = this.getStringParameter(PARAMETER_NEW_PASSWORD, "");
            this.confirmPassword = this.getStringParameter(PARAMETER_CONFIRM_PASSWORD, "");
        }

        @Override
        public String additionalValidations() {
            if (!this.page.isExternalAuthOnly()) {
                if (this.newPassword.isEmpty() && this.confirmPassword.isEmpty()) {
                    return "";
                }
                if (!this.newPassword.equals(this.confirmPassword)) {
                    return ERROR_PASSWORDS_DONT_MATCH;
                }
                if (!this.checkPasswordLength(this.newPassword)) {
                    return ERROR_WRONG_PASSWORD_LENGTH;
                }
                return "";
            }
            return "";
        }

        @Override
        public void addMoreBodyValues(Map<String, Object> body) {
            body.put(PARAMETER_NEW_PASSWORD, this.newPassword);
            body.put(PARAMETER_CONFIRM_PASSWORD, this.confirmPassword);
            body.put("minimumLength", 6);
            body.put("maximumLength", 12);
        }

        @Override
        public void setAdditionalProperties(UserAccount userAccount) {
            if (!this.newPassword.isEmpty() && !this.page.isExternalAuthOnly()) {
                userAccount.setMd5Password(Authenticator.applyMd5Encoding(this.newPassword));
                userAccount.setPasswordChangeRequired(false);
                userAccount.setPasswordLinkExpires(0L);
            }
        }

        @Override
        public void notifyUser() {
            if (!this.isEmailEnabled()) {
                return;
            }
            if (!this.emailHasChanged()) {
                return;
            }
            HashMap<String, Object> body = new HashMap<String, Object>();
            body.put("userAccount", this.page.getUserAccount());
            body.put("siteName", this.getSiteName());
            FreemarkerEmailMessage email = FreemarkerEmailFactory.createNewMessage(this.vreq);
            email.addRecipient(Message.RecipientType.TO, this.page.getUserAccount().getEmailAddress());
            email.setSubject(this.i18n.text("email_changed_subject", this.getSiteName()));
            email.setTemplate(EMAIL_TEMPLATE);
            email.setBodyMap(body);
            email.processTemplate();
            email.send();
            this.emailSent = true;
        }

        private boolean emailHasChanged() {
            return !this.page.getUserAccount().getEmailAddress().equals(this.originalEmail);
        }

        @Override
        public String getConfirmationCode() {
            return this.emailSent ? UserAccountsMyAccountPageStrategy.CONFIRM_EMAIL_SENT : UserAccountsMyAccountPageStrategy.CONFIRM_CHANGE;
        }
    }

    private static class ExternalAuthStrategy
    extends UserAccountsMyAccountPageStrategy {
        ExternalAuthStrategy(VitroRequest vreq, UserAccountsMyAccountPage page) {
            super(vreq, page);
        }

        @Override
        public void parseAdditionalParameters() {
        }

        @Override
        public String additionalValidations() {
            return "";
        }

        @Override
        public void addMoreBodyValues(Map<String, Object> body) {
            body.put("externalAuth", Boolean.TRUE);
        }

        @Override
        public void setAdditionalProperties(UserAccount userAccount) {
        }

        @Override
        public void notifyUser() {
        }

        @Override
        public String getConfirmationCode() {
            return UserAccountsMyAccountPageStrategy.CONFIRM_CHANGE;
        }
    }
}

