/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.admin;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.rdf.model.Model;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.FreemarkerHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.TemplateResponseValues;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ContextModelAccess;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.modelaccess.RequestModelAccess;
import edu.cornell.mannlib.vitro.webapp.utils.logging.ComplexStringFormatter;
import edu.cornell.mannlib.vitro.webapp.utils.logging.ToString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ShowSourcesController
extends FreemarkerHttpServlet {
    private static final Log log = LogFactory.getLog(ShowSourcesController.class);

    @Override
    protected AuthorizationRequest requiredActions(VitroRequest vreq) {
        return AuthorizationRequest.AUTHORIZED;
    }

    @Override
    protected ResponseValues processRequest(VitroRequest vreq) {
        return new TemplateResponseValues("admin-showSources.ftl", new SourcesMap(vreq));
    }

    private static class SourcesMap
    extends HashMap<String, Object> {
        private static final Object SAME_AS_CONTEXT = "Same as Context";
        private final RequestModelAccess reqModels;
        private final ContextModelAccess ctxModels;
        private final SortedSet<String> contentModelNames;
        private final SortedSet<String> configurationModelNames;
        private final SortedSet<String> allModelNames;

        public SourcesMap(VitroRequest vreq) {
            this.reqModels = ModelAccess.on((HttpServletRequest)vreq);
            this.ctxModels = ModelAccess.on(vreq.getSession().getServletContext());
            this.contentModelNames = new TreeSet<String>(this.ctxModels.getModelMaker(ModelAccess.WhichService.CONTENT).listModels().toList());
            this.configurationModelNames = new TreeSet<String>(this.ctxModels.getModelMaker(ModelAccess.WhichService.CONFIGURATION).listModels().toList());
            this.allModelNames = new TreeSet<String>(this.contentModelNames);
            this.allModelNames.addAll(this.configurationModelNames);
            this.addStructures(this.ctxModels, this.reqModels, "modelAccess");
            this.addStructures(this.ctxModels.getRDFService(ModelAccess.WhichService.CONTENT), this.reqModels.getRDFService(ModelAccess.WhichService.CONTENT, ModelAccess.LanguageOption.LANGUAGE_NEUTRAL), "rdfServices", ModelAccess.WhichService.CONTENT);
            this.addStructures(this.ctxModels.getRDFService(ModelAccess.WhichService.CONFIGURATION), this.reqModels.getRDFService(ModelAccess.WhichService.CONFIGURATION, ModelAccess.LanguageOption.LANGUAGE_NEUTRAL), "rdfServices", ModelAccess.WhichService.CONFIGURATION);
            this.addStructures(this.ctxModels.getDataset(ModelAccess.WhichService.CONTENT), this.reqModels.getDataset(ModelAccess.WhichService.CONTENT, ModelAccess.LanguageOption.LANGUAGE_NEUTRAL), "datasets", ModelAccess.WhichService.CONTENT);
            this.addStructures(this.ctxModels.getDataset(ModelAccess.WhichService.CONFIGURATION), this.reqModels.getDataset(ModelAccess.WhichService.CONFIGURATION, ModelAccess.LanguageOption.LANGUAGE_NEUTRAL), "datasets", ModelAccess.WhichService.CONFIGURATION);
            for (String modelName : this.contentModelNames) {
                this.addContextModel(this.ctxModels.getModelMaker(ModelAccess.WhichService.CONTENT).getModel(modelName), "models", ModelAccess.WhichService.CONTENT, ToString.modelName(modelName));
            }
            for (String modelName : this.configurationModelNames) {
                this.addContextModel(this.ctxModels.getModelMaker(ModelAccess.WhichService.CONFIGURATION).getModel(modelName), "models", ModelAccess.WhichService.CONFIGURATION, ToString.modelName(modelName));
            }
            for (String modelName : this.allModelNames) {
                this.addStructures(this.ctxModels.getOntModel(modelName), this.reqModels.getOntModel(modelName, ModelAccess.LanguageOption.LANGUAGE_NEUTRAL), "ontModels", ToString.modelName(modelName));
            }
        }

        private void addStructures(Object contextDataStructure, Object requestDataStructure, Object ... keys) {
            Map<String, Object> map = this.followPath(keys);
            map.put("context", this.formatStructure(contextDataStructure));
            if (String.valueOf(contextDataStructure).equals(String.valueOf(requestDataStructure))) {
                map.put("request", SAME_AS_CONTEXT);
            } else {
                map.put("request", this.formatStructure(requestDataStructure));
            }
            this.writeToLog(keys, "context", contextDataStructure);
            this.writeToLog(keys, "request", requestDataStructure);
        }

        private void addContextModel(Model model, Object ... keys) {
            Map<String, Object> map = this.followPath(keys);
            map.put("context", this.formatStructure(model));
            this.writeToLog(keys, "context", model);
        }

        private Map<String, Object> followPath(Object[] keys) {
            Map<String, Object> m = this;
            for (Object key : keys) {
                String stringKey = String.valueOf(key);
                if (!m.containsKey(stringKey)) {
                    m.put(stringKey, new TreeMap());
                }
                m = (Map)m.get(stringKey);
            }
            return m;
        }

        private void writeToLog(Object[] keys, String lastKey, Object dataStructure) {
            ArrayList<Object> allKeys = new ArrayList<Object>();
            allKeys.addAll(Arrays.asList(keys));
            allKeys.add(lastKey);
            log.info((Object)("Data structure: " + allKeys + " " + this.dsToString(dataStructure)));
        }

        private String dsToString(Object dataStructure) {
            if (dataStructure instanceof OntModel) {
                return ToString.ontModelToString((OntModel)dataStructure);
            }
            if (dataStructure instanceof Model) {
                return ToString.modelToString((Model)dataStructure);
            }
            if (dataStructure instanceof Graph) {
                return ToString.graphToString((Graph)dataStructure);
            }
            if (dataStructure instanceof RequestModelAccess || dataStructure instanceof ContextModelAccess) {
                return ToString.replaceModelNames(String.valueOf(dataStructure));
            }
            return String.valueOf(dataStructure);
        }

        private String formatStructure(Object dataStructure) {
            String dsString = this.dsToString(dataStructure);
            if (dataStructure instanceof RequestModelAccess || dataStructure instanceof ContextModelAccess) {
                return new ComplexStringFormatter(dsString, ".   ").toString();
            }
            return new ComplexStringFormatter(dsString).toString();
        }
    }
}

