/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.admin;

import edu.cornell.mannlib.vitro.webapp.controller.VitroHttpServlet;
import edu.cornell.mannlib.vitro.webapp.utils.threads.VitroBackgroundThread;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WaitForBackgroundThreadsController
extends VitroHttpServlet {
    private static final Log log = LogFactory.getLog(WaitForBackgroundThreadsController.class);
    private static final String PARAMETER_WAIT_LIMIT = "waitLimit";
    private static final String PARAMETER_RETURN = "return";
    private static final String HEADER_REFERER = "Referer";
    private static final String HEADER_LOCATION = "Location";
    private static final int DEFAULT_WAIT_LIMIT_VALUE = 30;
    private static final int POLLING_INTERVAL = 3;

    @Override
    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        int maximumWait = this.figureMaximumWait(req);
        String redirect = this.figureRedirect(req);
        Collection<String> remainingThreads = this.waitForThreads(maximumWait);
        if (remainingThreads.isEmpty()) {
            if (redirect == null) {
                this.sendOK(resp);
            } else {
                this.sendRedirect(resp, redirect);
            }
        } else {
            this.sendFailure(resp, maximumWait, remainingThreads);
        }
    }

    private int figureMaximumWait(HttpServletRequest req) {
        int value;
        String valueString = req.getParameter(PARAMETER_WAIT_LIMIT);
        if (valueString == null) {
            return 30;
        }
        try {
            value = Integer.parseInt(valueString);
        }
        catch (NumberFormatException e) {
            return 30;
        }
        if (value <= 0) {
            return 30;
        }
        log.debug((Object)("Maximum wait time (seconds): " + value));
        return value;
    }

    private String figureRedirect(HttpServletRequest req) {
        if (!req.getParameterMap().containsKey(PARAMETER_RETURN)) {
            return null;
        }
        Enumeration referers = req.getHeaders(HEADER_REFERER);
        if (referers == null || !referers.hasMoreElements()) {
            return null;
        }
        String redirect = (String)referers.nextElement();
        log.debug((Object)("Redirect is to '" + redirect + "'"));
        return redirect;
    }

    private Collection<String> waitForThreads(int maximumWait) {
        Collection<String> threadNames;
        int elapsedSeconds = 0;
        do {
            if ((threadNames = this.getNamesOfBusyThreads()).isEmpty()) {
                return Collections.emptySet();
            }
            try {
                log.debug((Object)"Waiting for 3 seconds.");
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                return Collections.singleton("Polling was interrupted");
            }
        } while ((elapsedSeconds += 3) < maximumWait);
        return threadNames;
    }

    private Collection<String> getNamesOfBusyThreads() {
        ArrayList<String> names = new ArrayList<String>();
        for (VitroBackgroundThread thread : VitroBackgroundThread.getThreads()) {
            VitroBackgroundThread.WorkLevelStamp stamp;
            if (!thread.isAlive() || (stamp = thread.getWorkLevel()) == null || stamp.getLevel() != VitroBackgroundThread.WorkLevel.WORKING) continue;
            names.add(thread.getName());
        }
        log.debug((Object)("Busy threads: " + names));
        return names;
    }

    private void sendOK(HttpServletResponse resp) throws IOException {
        log.debug((Object)"All threads are idle");
        resp.setStatus(200);
        resp.getWriter().println("<html><body>All threads are idle.</body></html>");
    }

    private void sendRedirect(HttpServletResponse resp, String redirect) {
        log.debug((Object)("All threads are idle. Redirecting to '" + redirect + "'"));
        resp.setStatus(307);
        resp.setHeader(HEADER_LOCATION, redirect);
    }

    private void sendFailure(HttpServletResponse resp, int maximumWait, Collection<String> namesOfBusyThreads) throws IOException {
        log.debug((Object)("Timeout after " + maximumWait + " seconds with busy threads: " + namesOfBusyThreads));
        resp.setStatus(503);
        resp.getWriter().println("<html><body>After " + maximumWait + " seconds, " + namesOfBusyThreads.size() + " threads are still busy: " + namesOfBusyThreads + "</body></html>");
    }
}

