/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.ajax;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.rdf.model.Model;
import edu.cornell.mannlib.vitro.webapp.controller.ajax.SparqlQueryAjaxController;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SparqlUtils {
    private static final Log log = LogFactory.getLog(SparqlQueryAjaxController.class);
    public static final String RESPONSE_MIME_TYPE = "application/javascript";
    public static final String PARAMETER_MODEL = "model";
    public static final String OPTION_MODEL_FULL = "full";
    public static final String OPTION_MODEL_USER_ACCOUNTS = "userAccounts";

    public static Query createQuery(String queryParam) throws AjaxControllerException {
        Query query = QueryFactory.create((String)queryParam, (Syntax)Syntax.syntaxARQ);
        if (!query.isSelectType()) {
            throw new AjaxControllerException(404, "Only 'select' queries are allowed.");
        }
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeQuery(HttpServletResponse response, Query query, Model model) throws IOException {
        Dataset dataset = DatasetFactory.create((Model)model);
        try (QueryExecution qe = QueryExecutionFactory.create((Query)query, (Dataset)dataset);){
            ResultSet results = qe.execSelect();
            response.setContentType(RESPONSE_MIME_TYPE);
            ServletOutputStream out = response.getOutputStream();
            ResultSetFormatter.outputAsJSON((OutputStream)out, (ResultSet)results);
        }
    }

    public static class AjaxControllerException
    extends Exception {
        private final int statusCode;

        public AjaxControllerException(int statusCode, String message) {
            super(message);
            this.statusCode = statusCode;
        }

        public int getStatusCode() {
            return this.statusCode;
        }
    }
}

