/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.api;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.ReadWrite;
import com.hp.hpl.jena.update.GraphStore;
import com.hp.hpl.jena.update.GraphStoreFactory;
import com.hp.hpl.jena.update.UpdateAction;
import com.hp.hpl.jena.update.UpdateFactory;
import com.hp.hpl.jena.update.UpdateRequest;
import edu.cornell.mannlib.vitro.webapp.application.ApplicationUtils;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.api.VitroApiServlet;
import edu.cornell.mannlib.vitro.webapp.dao.jena.RDFServiceDataset;
import edu.cornell.mannlib.vitro.webapp.modules.searchIndexer.SearchIndexer;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SparqlUpdateApiController
extends VitroApiServlet {
    private static final Log log = LogFactory.getLog(SparqlUpdateApiController.class);
    private static final AuthorizationRequest REQUIRED_ACTIONS = SimplePermission.USE_SPARQL_UPDATE_API.ACTION;

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        log.debug((Object)"Starting update");
        try {
            this.confirmAuthorization(req, REQUIRED_ACTIONS);
            UpdateRequest parsed = this.parseUpdateString(req);
            this.executeUpdate(req, parsed);
            this.do200response(resp);
        }
        catch (VitroApiServlet.AuthException e) {
            this.do403response(resp, e);
        }
        catch (ParseException e) {
            this.do400response(resp, e);
        }
        catch (Exception e) {
            this.do500response(resp, e);
        }
        log.debug((Object)"Update complete");
    }

    private UpdateRequest parseUpdateString(HttpServletRequest req) throws ParseException {
        String update = req.getParameter("update");
        if (StringUtils.isBlank((String)update)) {
            log.debug((Object)"No update parameter.");
            throw new ParseException("No 'update' parameter.");
        }
        if (!StringUtils.containsIgnoreCase((String)update, (String)"GRAPH")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No GRAPH uri in '" + update + "'"));
            }
            throw new ParseException("SPARQL update must specify a GRAPH URI.");
        }
        try {
            return UpdateFactory.create((String)update);
        }
        catch (Exception e) {
            log.debug((Object)"Problem parsing", (Throwable)e);
            throw new ParseException("Failed to parse SPARQL update", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeUpdate(HttpServletRequest req, UpdateRequest parsed) {
        VitroRequest vreq = new VitroRequest(req);
        SearchIndexer indexer = ApplicationUtils.instance().getSearchIndexer();
        RDFServiceDataset ds = new RDFServiceDataset(vreq.getUnfilteredRDFService());
        GraphStore graphStore = GraphStoreFactory.create((Dataset)ds);
        try {
            if (indexer != null) {
                indexer.pause();
            }
            if (ds.supportsTransactions()) {
                ds.begin(ReadWrite.WRITE);
            }
            UpdateAction.execute((UpdateRequest)parsed, (GraphStore)graphStore);
        }
        finally {
            if (ds.supportsTransactions()) {
                ds.commit();
                ds.end();
            }
            if (indexer != null) {
                indexer.unpause();
            }
        }
    }

    private void do200response(HttpServletResponse resp) throws IOException {
        this.sendShortResponse(200, "SPARQL update accepted.", resp);
    }

    private void do403response(HttpServletResponse resp, VitroApiServlet.AuthException e) throws IOException {
        this.sendShortResponse(403, e.getMessage(), resp);
    }

    private void do400response(HttpServletResponse resp, ParseException e) throws IOException {
        if (e.getCause() == null) {
            this.sendShortResponse(400, e.getMessage(), resp);
        } else {
            this.sendShortResponse(400, e.getMessage(), e.getCause(), resp);
        }
    }

    private void do500response(HttpServletResponse resp, Exception e) throws IOException {
        this.sendShortResponse(500, "Unknown error", e, resp);
    }

    private static class ParseException
    extends Exception {
        private ParseException(String message) {
            super(message);
        }

        private ParseException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

