/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.api;

import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyHelper;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.beans.UserAccount;
import edu.cornell.mannlib.vitro.webapp.controller.authenticate.Authenticator;
import edu.cornell.mannlib.vitro.webapp.utils.http.AcceptHeaderParsingException;
import edu.cornell.mannlib.vitro.webapp.utils.http.ContentTypeUtil;
import edu.cornell.mannlib.vitro.webapp.utils.http.NotAcceptableException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Collection;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VitroApiServlet
extends HttpServlet {
    private static final Log log = LogFactory.getLog(VitroApiServlet.class);

    protected void confirmAuthorization(HttpServletRequest req, AuthorizationRequest requiredActions) throws AuthException {
        UserAccount account;
        String email = req.getParameter("email");
        String password = req.getParameter("password");
        Authenticator auth = Authenticator.getInstance(req);
        if (auth.accountRequiresEditing(account = auth.getAccountForInternalAuth(email))) {
            log.debug((Object)("Account " + email + " requires editing."));
            throw new AuthException("user account must include first and last names and a valid email address.");
        }
        if (!auth.isCurrentPassword(account, password)) {
            log.debug((Object)("Invalid: '" + email + "'/'" + password + "'"));
            throw new AuthException("email/password combination is not valid");
        }
        if (!PolicyHelper.isAuthorizedForActions(req, email, password, requiredActions)) {
            log.debug((Object)("Not authorized: '" + email + "'"));
            throw new AuthException("Account is not authorized");
        }
        if (account.isPasswordChangeRequired()) {
            log.debug((Object)("Account " + email + " requires a new password."));
            throw new AuthException("user account requires a new password.");
        }
        log.debug((Object)("Authorized for '" + email + "'"));
    }

    protected String parseAcceptHeader(HttpServletRequest req, Collection<String> availableTypes, String defaultType) throws AcceptHeaderParsingException, NotAcceptableException {
        String acceptHeader = req.getHeader("Accept");
        if (acceptHeader == null) {
            return defaultType;
        }
        acceptHeader = acceptHeader + "," + defaultType + ";q=0.1";
        return ContentTypeUtil.bestContentType(acceptHeader, availableTypes);
    }

    protected void sendShortResponse(int statusCode, String message, HttpServletResponse resp) throws IOException {
        resp.setStatus(statusCode);
        PrintWriter writer = this.getWriter(resp);
        writer.println("<H1>" + statusCode + " " + message + "</H1>");
    }

    protected void sendShortResponse(int statusCode, String message, Throwable e, HttpServletResponse resp) throws IOException {
        log.warn((Object)("Unexpected exception: " + e), e);
        this.sendShortResponse(statusCode, message, resp);
        PrintWriter writer = this.getWriter(resp);
        writer.println("<pre>");
        e.printStackTrace(writer);
        writer.println("</pre>");
    }

    private PrintWriter getWriter(HttpServletResponse resp) throws IOException {
        try {
            return resp.getWriter();
        }
        catch (IllegalStateException e) {
            return new PrintWriter(new OutputStreamWriter((OutputStream)resp.getOutputStream()));
        }
    }

    protected static class BadParameterException
    extends Exception {
        public BadParameterException(String message) {
            super(message);
        }
    }

    protected static class AuthException
    extends Exception {
        public AuthException(String message) {
            super(message);
        }
    }
}

