/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.api.sparqlquery;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public enum RdfResultMediaType {
    TEXT("text/plain", true, "NTRIPLE", "N-TRIPLE"),
    RDF_XML("application/rdf+xml", true, "RDFXML", "RDF/XML"),
    N3("text/n3", true, "N3", "N3"),
    TTL("text/turtle", false, "N3", "TTL"),
    JSON("application/json", false, "N3", "JSON"),
    JSON_LD("application/ld+json", false, "N3", "JSON");

    private static final Map<String, RdfResultMediaType> contentTypesMap;
    private final String contentType;
    private final boolean nativeFormat;
    private final String serializationFormat;
    private final String jenaResponseFormat;

    private static Map<String, RdfResultMediaType> buildMap() {
        LinkedHashMap<String, RdfResultMediaType> map = new LinkedHashMap<String, RdfResultMediaType>();
        for (RdfResultMediaType value : RdfResultMediaType.values()) {
            map.put(value.contentType, value);
        }
        return Collections.unmodifiableMap(map);
    }

    public static Collection<String> contentTypes() {
        return contentTypesMap.keySet();
    }

    public static RdfResultMediaType fromContentType(String contentType) throws IllegalArgumentException {
        RdfResultMediaType type = contentTypesMap.get(contentType);
        if (type == null) {
            throw new IllegalArgumentException("No RdfResultMediaType has contentType='" + contentType + "'");
        }
        return type;
    }

    private RdfResultMediaType(String contentType, boolean nativeFormat, String serializationFormat, String jenaResponseFormat) {
        this.contentType = contentType;
        this.nativeFormat = nativeFormat;
        this.serializationFormat = serializationFormat;
        this.jenaResponseFormat = jenaResponseFormat;
    }

    public String getContentType() {
        return this.contentType;
    }

    public boolean isNativeFormat() {
        return this.nativeFormat;
    }

    public String getSerializationFormat() {
        return this.serializationFormat;
    }

    public String getJenaResponseFormat() {
        return this.jenaResponseFormat;
    }

    static {
        contentTypesMap = RdfResultMediaType.buildMap();
    }
}

