/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.api.sparqlquery;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryParseException;
import edu.cornell.mannlib.vitro.webapp.controller.api.sparqlquery.InvalidQueryTypeException;
import edu.cornell.mannlib.vitro.webapp.controller.api.sparqlquery.SparqlQueryApiAskExecutor;
import edu.cornell.mannlib.vitro.webapp.controller.api.sparqlquery.SparqlQueryApiConstructExecutor;
import edu.cornell.mannlib.vitro.webapp.controller.api.sparqlquery.SparqlQueryApiDescribeExecutor;
import edu.cornell.mannlib.vitro.webapp.controller.api.sparqlquery.SparqlQueryApiSelectExecutor;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceException;
import edu.cornell.mannlib.vitro.webapp.utils.SparqlQueryUtils;
import edu.cornell.mannlib.vitro.webapp.utils.http.AcceptHeaderParsingException;
import edu.cornell.mannlib.vitro.webapp.utils.http.NotAcceptableException;
import java.io.IOException;
import java.io.OutputStream;

public abstract class SparqlQueryApiExecutor {
    protected final RDFService rdfService;
    protected final String queryString;

    public static SparqlQueryApiExecutor instance(RDFService rdfService, String queryString, String acceptHeader) throws NotAcceptableException, QueryParseException, InvalidQueryTypeException, AcceptHeaderParsingException {
        if (rdfService == null) {
            throw new NullPointerException("rdfService may not be null.");
        }
        if (queryString == null) {
            throw new NullPointerException("queryString may not be null.");
        }
        Query query = SparqlQueryUtils.create(queryString);
        if (query.isSelectType()) {
            return new SparqlQueryApiSelectExecutor(rdfService, queryString, acceptHeader);
        }
        if (query.isAskType()) {
            return new SparqlQueryApiAskExecutor(rdfService, queryString, acceptHeader);
        }
        if (query.isConstructType()) {
            return new SparqlQueryApiConstructExecutor(rdfService, queryString, acceptHeader);
        }
        if (query.isDescribeType()) {
            return new SparqlQueryApiDescribeExecutor(rdfService, queryString, acceptHeader);
        }
        throw new InvalidQueryTypeException("The API only accepts SELECT, ASK, CONSTRUCT, or DESCRIBE queries: '" + queryString + "'");
    }

    protected SparqlQueryApiExecutor(RDFService rdfService, String queryString) {
        this.rdfService = rdfService;
        this.queryString = queryString;
    }

    public abstract String getMediaType();

    public abstract void executeAndFormat(OutputStream var1) throws RDFServiceException, IOException;
}

