/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.api.sparqlquery;

import com.github.jsonldjava.core.JSONLD;
import com.github.jsonldjava.core.JSONLDProcessingError;
import com.github.jsonldjava.core.RDFParser;
import com.github.jsonldjava.impl.JenaRDFParser;
import com.github.jsonldjava.utils.JSONUtils;
import com.hp.hpl.jena.rdf.model.Model;
import edu.cornell.mannlib.vitro.webapp.controller.api.sparqlquery.RdfResultMediaType;
import edu.cornell.mannlib.vitro.webapp.controller.api.sparqlquery.SparqlQueryApiExecutor;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceException;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.RDFServiceUtils;
import edu.cornell.mannlib.vitro.webapp.utils.http.AcceptHeaderParsingException;
import edu.cornell.mannlib.vitro.webapp.utils.http.ContentTypeUtil;
import edu.cornell.mannlib.vitro.webapp.utils.http.NotAcceptableException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collection;
import org.apache.commons.io.IOUtils;

abstract class SparqlQueryApiRdfProducer
extends SparqlQueryApiExecutor {
    protected final RdfResultMediaType mediaType;

    public SparqlQueryApiRdfProducer(RDFService rdfService, String queryString, String acceptHeader) throws AcceptHeaderParsingException, NotAcceptableException {
        super(rdfService, queryString);
        Collection<String> contentTypes = RdfResultMediaType.contentTypes();
        String bestType = ContentTypeUtil.bestContentType(acceptHeader, contentTypes);
        this.mediaType = RdfResultMediaType.fromContentType(bestType);
    }

    @Override
    public String getMediaType() {
        return this.mediaType.getContentType();
    }

    @Override
    public void executeAndFormat(OutputStream out) throws RDFServiceException, IOException {
        InputStream rawResult = this.getRawResultStream();
        if (this.mediaType.isNativeFormat()) {
            IOUtils.copy((InputStream)rawResult, (OutputStream)out);
        } else if (this.mediaType.getJenaResponseFormat().equals("JSON")) {
            try {
                JenaRDFParser parser = new JenaRDFParser();
                Object json = JSONLD.fromRDF((Object)this.parseToModel(rawResult), (RDFParser)parser);
                JSONUtils.write((Writer)new OutputStreamWriter(out, "UTF-8"), (Object)json);
            }
            catch (JSONLDProcessingError e) {
                throw new RDFServiceException("Could not convert from Jena model to JSON-LD", e);
            }
        } else {
            this.parseToModel(rawResult).write(out, this.mediaType.getJenaResponseFormat());
        }
    }

    private Model parseToModel(InputStream rawResult) {
        RDFService.ModelSerializationFormat format = RDFService.ModelSerializationFormat.valueOf(this.mediaType.getSerializationFormat());
        return RDFServiceUtils.parseModel(rawResult, format);
    }

    protected abstract InputStream getRawResultStream() throws RDFServiceException;
}

