/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.authenticate;

import edu.cornell.mannlib.vitro.webapp.controller.authenticate.Authenticator;
import edu.cornell.mannlib.vitro.webapp.controller.login.LoginProcessBean;
import java.io.IOException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BaseLoginServlet
extends HttpServlet {
    private static final Log log = LogFactory.getLog(BaseLoginServlet.class);

    protected static LoginProcessBean.Message messageLoginFailed(HttpServletRequest req) {
        return new LoginProcessBean.Message(req, LoginProcessBean.MLevel.ERROR, "external_login_failed", new Object[0]);
    }

    protected static LoginProcessBean.Message messageLoginDisabled(HttpServletRequest req) {
        return new LoginProcessBean.Message(req, LoginProcessBean.MLevel.ERROR, "logins_temporarily_disabled", new Object[0]);
    }

    protected Authenticator getAuthenticator(HttpServletRequest req) {
        return Authenticator.getInstance(req);
    }

    protected void complainAndReturnToReferrer(HttpServletRequest req, HttpServletResponse resp, String sessionAttributeForReferrer, LoginProcessBean.Message message) throws IOException {
        log.debug((Object)message);
        LoginProcessBean.getBean(req).setMessage(message);
        String referrer = (String)req.getSession().getAttribute(sessionAttributeForReferrer);
        log.debug((Object)("returning to referrer: " + referrer));
        if (referrer == null) {
            referrer = this.figureHomePageUrl(req);
            log.debug((Object)("returning to home page: " + referrer));
        }
        req.getSession().removeAttribute(sessionAttributeForReferrer);
        resp.sendRedirect(referrer);
    }

    protected String figureHomePageUrl(HttpServletRequest req) {
        StringBuffer url = req.getRequestURL();
        String uri = req.getRequestURI();
        int authLength = url.length() - uri.length();
        String auth = url.substring(0, authLength);
        return auth + req.getContextPath();
    }
}

