/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.datatools.dumprestore;

import edu.cornell.mannlib.vitro.webapp.controller.datatools.dumprestore.AbstractDumpRestoreAction;
import edu.cornell.mannlib.vitro.webapp.controller.datatools.dumprestore.DumpRestoreController;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceException;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class DumpModelsAction
extends AbstractDumpRestoreAction {
    private static final Log log = LogFactory.getLog(DumpModelsAction.class);
    private static final String N_QUADS_EXTENSION = ".nq";
    private static final String N_QUADS_MIME_TYPE = "application/n-quads";
    private final HttpServletResponse resp;
    private final ModelAccess.WhichService which;
    private final String queryString;

    DumpModelsAction(HttpServletRequest req, HttpServletResponse resp) throws DumpRestoreController.BadRequestException {
        super(req);
        this.resp = resp;
        this.which = this.getEnumFromParameter(ModelAccess.WhichService.class, "which");
        this.queryString = req.getQueryString();
    }

    void redirectToFilename() throws IOException {
        String filename = this.which + N_QUADS_EXTENSION;
        String urlPath = this.req.getContextPath() + this.req.getServletPath() + "/dump";
        this.resp.sendRedirect(urlPath + "/" + filename + "?" + this.queryString);
    }

    void dumpModels() {
        try {
            RDFService rdfService = this.getRdfService(this.which);
            String query = "SELECT * WHERE { GRAPH ?g {?s ?p ?o}}";
            this.resp.setContentType(N_QUADS_MIME_TYPE);
            this.dumpNQuads(rdfService, query);
        }
        catch (Throwable t) {
            log.error((Object)("Failed to dump " + this.which + " models as N-Quads."), t);
        }
    }

    private void dumpNQuads(RDFService rdfService, String query) throws RDFServiceException, IOException {
        rdfService.serializeAll((OutputStream)this.resp.getOutputStream());
    }
}

