/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.edit;

import edu.cornell.mannlib.vedit.beans.EditProcessObject;
import edu.cornell.mannlib.vedit.beans.FormObject;
import edu.cornell.mannlib.vedit.beans.Option;
import edu.cornell.mannlib.vedit.controller.BaseEditController;
import edu.cornell.mannlib.vedit.util.FormUtils;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.beans.ApplicationBean;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.ApplicationDao;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ApplicationBeanRetryController
extends BaseEditController {
    private static final Log log = LogFactory.getLog((String)ApplicationBeanRetryController.class.getName());

    @Override
    public void doPost(HttpServletRequest req, HttpServletResponse response) {
        if (!this.isAuthorizedToDisplayPage(req, response, SimplePermission.EDIT_SITE_INFORMATION.ACTION)) {
            return;
        }
        VitroRequest request = new VitroRequest(req);
        try {
            super.doGet((HttpServletRequest)request, response);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        EditProcessObject epo = super.createEpo((HttpServletRequest)request);
        epo.setBeanClass(ApplicationBean.class);
        String action = "update";
        ApplicationDao aDao = request.getUnfilteredWebappDaoFactory().getApplicationDao();
        ApplicationBean applicationForEditing = aDao.getApplicationBean();
        epo.setDataAccessObject(aDao);
        if (!epo.getUseRecycledBean()) {
            action = "update";
            epo.setOriginalBean(applicationForEditing);
        } else {
            applicationForEditing = (ApplicationBean)epo.getNewBean();
            action = "update";
            log.debug((Object)"using newBean");
        }
        try {
            epo.setGetMethod(aDao.getClass().getDeclaredMethod("getApplicationBean", new Class[0]));
        }
        catch (NoSuchMethodException e) {
            log.error((Object)"could not find the getApplicationBean method in the facade");
        }
        FormObject foo = new FormObject();
        foo.setErrorMap(epo.getErrMsgMap());
        HashMap<String, List<Option>> optionMap = new HashMap<String, List<Option>>();
        List<Option> themeOptions = this.getThemeOptions(applicationForEditing);
        optionMap.put("ThemeDir", themeOptions);
        foo.setOptionLists(optionMap);
        epo.setFormObject(foo);
        FormUtils.populateFormFromBean(applicationForEditing, epo.getAction(), foo);
        RequestDispatcher rd = request.getRequestDispatcher("/templates/page/basicPage.jsp");
        request.setAttribute("bodyJsp", "/templates/edit/formContact.jsp");
        request.setAttribute("formJsp", "/templates/edit/specific/applicationBean_retry.jsp");
        request.setAttribute("scripts", "/templates/edit/formBasic.js");
        request.setAttribute("title", "Site Information");
        request.setAttribute("_action", action);
        request.setAttribute("unqualifiedClassName", "ApplicationBean");
        this.setRequestAttributes((HttpServletRequest)request, epo);
        try {
            rd.forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        this.doPost(request, response);
    }

    private final List<Option> getThemeOptions(ApplicationBean application) {
        ServletContext sc = this.getServletContext();
        boolean doSort = true;
        List<String> themeNames = ApplicationBean.themeInfo.getThemeNames();
        String currentThemeDir = application.getThemeDir();
        Iterator<String> i = themeNames.iterator();
        ArrayList<Option> themeOptions = new ArrayList<Option>(themeNames.size());
        while (i.hasNext()) {
            String themeName = i.next();
            String themeDir = "themes/" + themeName + "/";
            boolean selected = themeDir.equals(currentThemeDir);
            themeOptions.add(new Option(themeDir, themeName, selected));
        }
        return themeOptions;
    }
}

