/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.edit;

import edu.cornell.mannlib.vedit.beans.EditProcessObject;
import edu.cornell.mannlib.vedit.beans.FormObject;
import edu.cornell.mannlib.vedit.beans.Option;
import edu.cornell.mannlib.vedit.controller.BaseEditController;
import edu.cornell.mannlib.vedit.util.FormUtils;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.beans.DataProperty;
import edu.cornell.mannlib.vitro.webapp.beans.DataPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.DataPropertyStatementImpl;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.DataPropertyDao;
import edu.cornell.mannlib.vitro.webapp.dao.DataPropertyStatementDao;
import edu.cornell.mannlib.vitro.webapp.dao.IndividualDao;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataPropertyStatementRetryController
extends BaseEditController {
    private static final Log log = LogFactory.getLog((String)DataPropertyStatementRetryController.class.getName());

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) {
        if (!this.isAuthorizedToDisplayPage(request, response, SimplePermission.DO_BACK_END_EDITING.ACTION)) {
            return;
        }
        EditProcessObject epo = super.createEpo(request);
        String action = "insert";
        VitroRequest vreq = new VitroRequest(request);
        DataPropertyStatementDao dataPropertyStatementDao = vreq.getUnfilteredWebappDaoFactory().getDataPropertyStatementDao();
        epo.setDataAccessObject(dataPropertyStatementDao);
        DataPropertyDao dpDao = vreq.getUnfilteredWebappDaoFactory().getDataPropertyDao();
        IndividualDao eDao = vreq.getUnfilteredWebappDaoFactory().getIndividualDao();
        epo.setBeanClass(DataPropertyStatement.class);
        DataPropertyStatement objectForEditing = null;
        if (!epo.getUseRecycledBean()) {
            objectForEditing = new DataPropertyStatementImpl();
            this.populateBeanFromParams(objectForEditing, (HttpServletRequest)vreq);
            if (vreq.getParameter("multiplexedParam") != null) {
                action = "update";
            }
            epo.setOriginalBean(objectForEditing);
        } else {
            objectForEditing = (DataPropertyStatement)epo.getNewBean();
        }
        FormObject foo = new FormObject();
        foo.setValues(new HashMap<String, String>());
        HashMap<String, List<Option>> OptionMap = new HashMap<String, List<Option>>();
        LinkedList<Option> entityList = new LinkedList<Option>();
        if (objectForEditing.getIndividualURI() != null) {
            Individual individual = eDao.getIndividualByURI(objectForEditing.getIndividualURI());
            entityList.add(new Option(individual.getURI(), individual.getName(), true));
        } else {
            entityList.add(new Option("-1", "Error: the individual must be specified", true));
        }
        OptionMap.put("IndividualURI", entityList);
        DataProperty dp = dpDao.getDataPropertyByURI(objectForEditing.getDatapropURI());
        if (dp == null) {
            foo.getValues().put("Dataprop", "Error: the data property must be specified");
        } else {
            foo.getValues().put("Dataprop", dp.getPublicName());
        }
        foo.setOptionLists(OptionMap);
        epo.setFormObject(foo);
        FormUtils.populateFormFromBean(objectForEditing, action, foo);
        RequestDispatcher rd = request.getRequestDispatcher("/templates/page/basicPage.jsp");
        request.setAttribute("bodyJsp", (Object)"/templates/edit/formBasic.jsp");
        request.setAttribute("formJsp", (Object)"/templates/edit/specific/ents2data_retry.jsp");
        request.setAttribute("scripts", (Object)"/templates/edit/formBasic.js");
        request.setAttribute("title", (Object)"Individual Data Editing Form");
        request.setAttribute("_action", (Object)action);
        request.setAttribute("unqualifiedClassName", (Object)"DataPropertyStatement");
        this.setRequestAttributes(request, epo);
        try {
            rd.forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception e) {
            log.error((Object)(this.getClass().getName() + " could not forward to view."));
            log.error((Object)e.getMessage());
            log.error((Object)e.getStackTrace());
        }
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        this.doPost(request, response);
    }
}

