/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.edit;

import edu.cornell.mannlib.vedit.beans.EditProcessObject;
import edu.cornell.mannlib.vedit.beans.FormObject;
import edu.cornell.mannlib.vedit.beans.Option;
import edu.cornell.mannlib.vedit.controller.BaseEditController;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.beans.ApplicationBean;
import edu.cornell.mannlib.vitro.webapp.beans.DataProperty;
import edu.cornell.mannlib.vitro.webapp.beans.Ontology;
import edu.cornell.mannlib.vitro.webapp.beans.PropertyGroup;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.DataPropertyDao;
import edu.cornell.mannlib.vitro.webapp.dao.PropertyGroupDao;
import edu.cornell.mannlib.vitro.webapp.dao.VClassDao;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DatapropEditController
extends BaseEditController {
    private static final Log log = LogFactory.getLog((String)DatapropEditController.class.getName());

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) {
        Ontology ont;
        if (!this.isAuthorizedToDisplayPage(request, response, SimplePermission.EDIT_ONTOLOGY.ACTION)) {
            return;
        }
        VitroRequest vreq = new VitroRequest(request);
        int NUM_COLS = 18;
        String datapropURI = request.getParameter("uri");
        DataPropertyDao dpDao = vreq.getUnfilteredWebappDaoFactory().getDataPropertyDao();
        DataPropertyDao dpDaoLangNeut = vreq.getLanguageNeutralWebappDaoFactory().getDataPropertyDao();
        VClassDao vcDao = vreq.getLanguageNeutralWebappDaoFactory().getVClassDao();
        VClassDao vcDaoWLang = vreq.getUnfilteredWebappDaoFactory().getVClassDao();
        DataProperty dp = dpDao.getDataPropertyByURI(datapropURI);
        DataProperty pLangNeut = dpDaoLangNeut.getDataPropertyByURI(request.getParameter("uri"));
        PropertyGroupDao pgDao = vreq.getUnfilteredWebappDaoFactory().getPropertyGroupDao();
        ArrayList<String> results = new ArrayList<String>();
        results.add("data property");
        results.add("public display label");
        results.add("property group");
        results.add("ontology");
        results.add("RDF local name");
        results.add("domain class");
        results.add("range datatype");
        results.add("functional");
        results.add("public description");
        results.add("example");
        results.add("editor description");
        results.add("display level");
        results.add("update level");
        results.add("display tier");
        results.add("display limit");
        results.add("custom entry form");
        results.add("URI");
        results.add("publish level");
        RequestDispatcher rd = request.getRequestDispatcher("/templates/page/basicPage.jsp");
        results.add(dp.getPickListName());
        results.add(dp.getPublicName() == null ? "(no public label)" : dp.getPublicName());
        if (dp.getGroupURI() != null) {
            PropertyGroup pGroup = pgDao.getGroupByURI(dp.getGroupURI());
            if (pGroup != null) {
                results.add(pGroup.getName());
            } else {
                results.add(dp.getGroupURI());
            }
        } else {
            results.add("(unspecified)");
        }
        String ontologyName = null;
        if (dp.getNamespace() != null && (ont = vreq.getUnfilteredWebappDaoFactory().getOntologyDao().getOntologyByURI(dp.getNamespace())) != null && ont.getName() != null) {
            ontologyName = ont.getName();
        }
        results.add(ontologyName == null ? "(not identified)" : ontologyName);
        results.add(dp.getLocalName());
        String domainStr = "";
        if (pLangNeut.getDomainVClassURI() != null) {
            VClass domainClass = vcDao.getVClassByURI(pLangNeut.getDomainVClassURI());
            VClass domainWLang = vcDaoWLang.getVClassByURI(pLangNeut.getDomainVClassURI());
            if (domainClass != null && domainClass.getURI() != null && domainClass.getPickListName() != null) {
                try {
                    domainStr = domainClass.isAnonymous() ? domainClass.getPickListName() : "<a href=\"vclassEdit?uri=" + URLEncoder.encode(domainClass.getURI(), "UTF-8") + "\">" + domainWLang.getPickListName() + "</a>";
                }
                catch (UnsupportedEncodingException e) {
                    log.error((Object)e, (Throwable)e);
                }
            }
        }
        results.add(domainStr);
        String rangeStr = dp.getRangeDatatypeURI() == null ? "<i>untyped</i> (rdfs:Literal)" : dp.getRangeDatatypeURI();
        results.add(rangeStr);
        results.add(dp.getFunctional() ? "true" : "false");
        String publicDescriptionStr = dp.getPublicDescription() == null ? "" : dp.getPublicDescription();
        results.add(publicDescriptionStr);
        String exampleStr = dp.getExample() == null ? "" : dp.getExample();
        results.add(exampleStr);
        String descriptionStr = dp.getDescription() == null ? "" : dp.getDescription();
        results.add(descriptionStr);
        results.add(dp.getHiddenFromDisplayBelowRoleLevel() == null ? "(unspecified)" : dp.getHiddenFromDisplayBelowRoleLevel().getDisplayLabel());
        results.add(dp.getProhibitedFromUpdateBelowRoleLevel() == null ? "(unspecified)" : dp.getProhibitedFromUpdateBelowRoleLevel().getUpdateLabel());
        results.add(String.valueOf(dp.getDisplayTier()));
        results.add(String.valueOf(dp.getDisplayLimit()));
        results.add(dp.getCustomEntryForm() == null ? "(unspecified)" : dp.getCustomEntryForm());
        results.add(dp.getURI() == null ? "" : dp.getURI());
        results.add(dp.getHiddenFromPublishBelowRoleLevel() == null ? "(unspecified)" : dp.getHiddenFromPublishBelowRoleLevel().getDisplayLabel());
        request.setAttribute("results", results);
        request.setAttribute("columncount", (Object)18);
        request.setAttribute("suppressquery", (Object)"true");
        boolean FORCE_NEW = true;
        EditProcessObject epo = super.createEpo(request, FORCE_NEW);
        FormObject foo = new FormObject();
        HashMap<String, List<Option>> OptionMap = new HashMap<String, List<Option>>();
        foo.setOptionLists(OptionMap);
        epo.setFormObject(foo);
        DataPropertyDao assertionsDpDao = vreq.getUnfilteredAssertionsWebappDaoFactory().getDataPropertyDao();
        List<DataProperty> superProps = this.getDataPropertiesForURIList(assertionsDpDao.getSuperPropertyURIs(dp.getURI(), false), assertionsDpDao);
        this.sortForPickList(superProps, vreq);
        request.setAttribute("superproperties", superProps);
        List<DataProperty> subProps = this.getDataPropertiesForURIList(assertionsDpDao.getSubPropertyURIs(dp.getURI()), assertionsDpDao);
        this.sortForPickList(subProps, vreq);
        request.setAttribute("subproperties", subProps);
        List<DataProperty> eqProps = this.getDataPropertiesForURIList(assertionsDpDao.getEquivalentPropertyURIs(dp.getURI()), assertionsDpDao);
        this.sortForPickList(eqProps, vreq);
        request.setAttribute("equivalentProperties", eqProps);
        ApplicationBean appBean = vreq.getAppBean();
        request.setAttribute("epoKey", (Object)epo.getKey());
        request.setAttribute("datatypeProperty", (Object)dp);
        request.setAttribute("bodyJsp", (Object)"/templates/edit/specific/dataprops_edit.jsp");
        request.setAttribute("title", (Object)"Data Property Control Panel");
        request.setAttribute("css", (Object)("<link rel=\"stylesheet\" type=\"text/css\" href=\"" + appBean.getThemeDir() + "css/edit.css\"/>"));
        try {
            rd.forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception e) {
            log.error((Object)"DatapropEditController could not forward to view.");
            log.error((Object)e.getMessage());
            log.error((Object)e.getStackTrace());
        }
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        this.doPost(request, response);
    }

    private List<DataProperty> getDataPropertiesForURIList(List<String> propertyURIs, DataPropertyDao dpDao) {
        ArrayList<DataProperty> properties = new ArrayList<DataProperty>();
        for (String propertyURI : propertyURIs) {
            DataProperty property = dpDao.getDataPropertyByURI(propertyURI);
            if (property == null) continue;
            properties.add(property);
        }
        return properties;
    }
}

