/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.edit;

import edu.cornell.mannlib.vedit.beans.EditProcessObject;
import edu.cornell.mannlib.vedit.controller.BaseEditController;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.IndividualDao;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IndividualTypeOperationController
extends BaseEditController {
    private static final Log log = LogFactory.getLog((String)IndividualTypeOperationController.class.getName());

    @Override
    public void doGet(HttpServletRequest req, HttpServletResponse response) {
        String referer;
        if (!this.isAuthorizedToDisplayPage(req, response, SimplePermission.DO_BACK_END_EDITING.ACTION)) {
            return;
        }
        VitroRequest request = new VitroRequest(req);
        String defaultLandingPage = this.getDefaultLandingPage((HttpServletRequest)request);
        HashMap epoHash = null;
        EditProcessObject epo = null;
        try {
            epoHash = (HashMap)request.getSession().getAttribute("epoHash");
            epo = (EditProcessObject)epoHash.get(request.getParameter("_epoKey"));
        }
        catch (NullPointerException e) {
            try {
                response.sendRedirect(defaultLandingPage);
            }
            catch (IOException f) {
                log.error((Object)f, (Throwable)f);
                throw new RuntimeException(f);
            }
            return;
        }
        if (epo == null) {
            log.error((Object)"null epo");
            try {
                response.sendRedirect(defaultLandingPage);
            }
            catch (IOException e) {
                log.error((Object)e, (Throwable)e);
                throw new RuntimeException(e);
            }
            return;
        }
        IndividualDao dao = request.getUnfilteredAssertionsWebappDaoFactory().getIndividualDao();
        if (request.getParameter("_cancel") == null) {
            try {
                if (request.getParameter("operation").equals("remove")) {
                    String[] typeURIstrs = request.getParameterValues("TypeURI");
                    String individualURIstr = request.getParameter("individualURI");
                    if (individualURIstr != null) {
                        for (int i = 0; i < typeURIstrs.length; ++i) {
                            dao.removeVClass(individualURIstr, typeURIstrs[i]);
                        }
                    }
                } else if (request.getParameter("operation").equals("add")) {
                    dao.addVClass(request.getParameter("individualURI"), request.getParameter("TypeURI"));
                }
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
            }
        }
        if ((referer = epo.getReferer()) == null) {
            try {
                response.sendRedirect(defaultLandingPage);
            }
            catch (IOException e) {
                log.error((Object)e, (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        try {
            response.sendRedirect(referer);
        }
        catch (IOException e) {
            log.error((Object)e, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) {
        this.doGet(request, response);
    }
}

