/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.edit;

import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import edu.cornell.mannlib.vedit.beans.EditProcessObject;
import edu.cornell.mannlib.vedit.controller.BaseEditController;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.edit.IndividualTypeOperationController;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NamespacePrefixOperationController
extends BaseEditController {
    private static final Log log = LogFactory.getLog((String)IndividualTypeOperationController.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doPost(HttpServletRequest req, HttpServletResponse response) {
        String referer;
        if (!this.isAuthorizedToDisplayPage(req, response, SimplePermission.USE_MISCELLANEOUS_ADMIN_PAGES.ACTION)) {
            return;
        }
        VitroRequest request = new VitroRequest(req);
        String defaultLandingPage = this.getDefaultLandingPage((HttpServletRequest)request);
        HashMap epoHash = null;
        EditProcessObject epo = null;
        try {
            epoHash = (HashMap)request.getSession().getAttribute("epoHash");
            epo = (EditProcessObject)epoHash.get(request.getParameter("_epoKey"));
        }
        catch (NullPointerException e) {
            try {
                response.sendRedirect(defaultLandingPage);
            }
            catch (IOException f) {
                log.error((Object)f, (Throwable)f);
                throw new RuntimeException(f);
            }
            return;
        }
        if (epo == null) {
            log.error((Object)"null epo");
            try {
                response.sendRedirect(defaultLandingPage);
            }
            catch (IOException e) {
                log.error((Object)e, (Throwable)e);
                throw new RuntimeException(e);
            }
            return;
        }
        if (request.getParameter("_cancel") == null) {
            OntModel ontModel = ModelAccess.on(this.getServletContext()).getOntModel();
            String namespaceStr = request.getParameter("namespace");
            String prefixStr = request.getParameter("prefix");
            if (namespaceStr != null && prefixStr != null) {
                Property namespaceURIProp = ontModel.getProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#namespaceURI");
                ontModel.enterCriticalSection(false);
                try {
                    Statement stmt;
                    Resource namespaceRes;
                    Individual namespaceInd = null;
                    StmtIterator stmtIt = ontModel.listStatements((Resource)null, namespaceURIProp, (RDFNode)ontModel.createLiteral(namespaceStr));
                    if (stmtIt.hasNext() && (namespaceRes = (stmt = stmtIt.nextStatement()).getSubject()).canAs(Individual.class)) {
                        namespaceInd = (Individual)namespaceRes.as(Individual.class);
                    }
                    if (namespaceInd == null) {
                        namespaceInd = ontModel.createIndividual(ontModel.getResource("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#Namespace"));
                        namespaceInd.addProperty(namespaceURIProp, namespaceStr);
                    }
                    HashSet<Individual> mappingSet = new HashSet<Individual>();
                    StmtIterator mappingStatementIt = namespaceInd.listProperties(ontModel.getProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#hasPrefixMapping"));
                    while (mappingStatementIt.hasNext()) {
                        Statement stmt2 = mappingStatementIt.nextStatement();
                        if (!stmt2.getObject().canAs(Individual.class)) continue;
                        mappingSet.add((Individual)stmt2.getObject().as(Individual.class));
                    }
                    for (Individual oldMapping : mappingSet) {
                        oldMapping.remove();
                    }
                    if (request.getParameter("_delete") == null) {
                        Individual newMappingInd = ontModel.createIndividual(ontModel.getResource("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#NamespacePrefixMapping"));
                        newMappingInd.addProperty(ontModel.getProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#namespacePrefix"), prefixStr);
                        namespaceInd.addProperty(ontModel.getProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#hasPrefixMapping"), (RDFNode)newMappingInd);
                    }
                }
                finally {
                    ontModel.leaveCriticalSection();
                }
            }
        }
        if ((referer = epo.getReferer()) == null) {
            try {
                response.sendRedirect(defaultLandingPage);
            }
            catch (IOException e) {
                log.error((Object)e, (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        try {
            response.sendRedirect(referer);
        }
        catch (IOException e) {
            log.error((Object)e, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) {
    }
}

