/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.edit;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.shared.Lock;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.ajax.VitroAjaxController;
import edu.cornell.mannlib.vitro.webapp.dao.jena.DependentResourceDeleteJena;
import edu.cornell.mannlib.vitro.webapp.dao.jena.event.EditEvent;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.N3EditUtils;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.StandardModelSelector;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PrimitiveRdfEdit
extends VitroAjaxController {
    private static final long serialVersionUID = 1L;
    Log log = LogFactory.getLog((String)PrimitiveRdfEdit.class.getName());

    @Override
    protected AuthorizationRequest requiredActions(VitroRequest vreq) {
        return SimplePermission.USE_BASIC_AJAX_CONTROLLERS.ACTION;
    }

    @Override
    protected void doRequest(VitroRequest vreq, HttpServletResponse response) throws ServletException, IOException {
        String format = vreq.getParameter("RdfFormat");
        if (format == null) {
            format = "N3";
        }
        if (!("N-TRIPLE".equals(format) || "TURTLE".equals(format) || "TTL".equals(format) || "N3".equals(format) || "RDF/XML-ABBREV".equals(format) || "RDF/XML".equals(format))) {
            this.doError(response, "RdfFormat was not recognized.", 500);
            return;
        }
        Set<Model> additions = null;
        try {
            additions = this.parseRdfParam(vreq.getParameterValues("additions"), format);
        }
        catch (Exception e) {
            this.doError(response, "Error reading RDF, set log level to debug for this class to get error messages in the server logs.", 400);
            return;
        }
        Set<Model> retractions = null;
        try {
            retractions = this.parseRdfParam(vreq.getParameterValues("retractions"), format);
        }
        catch (Exception e) {
            this.doError(response, "Error reading RDF, set log level to debug for this class to get error messages in the server logs.", 400);
            return;
        }
        String editorUri = N3EditUtils.getEditorUri((HttpServletRequest)vreq);
        try {
            Model a = this.mergeModels(additions);
            Model r = this.mergeModels(retractions);
            Model toBeAdded = a.difference(r);
            Model toBeRetracted = r.difference(a);
            Model depResRetractions = DependentResourceDeleteJena.getDependentResourceDeleteForChange(toBeAdded, toBeRetracted, this.getWriteModel(vreq));
            toBeRetracted.add(depResRetractions);
            this.processChanges(editorUri, this.getWriteModel(vreq), toBeAdded, toBeRetracted);
        }
        catch (Exception e) {
            this.doError(response, e.getMessage(), 500);
        }
    }

    void processChanges(String editorUri, Model writeModel, Model toBeAdded, Model toBeRetracted) throws Exception {
        Lock lock = null;
        this.log.debug((Object)"Model to be retracted is");
        StringWriter sw = new StringWriter();
        toBeRetracted.write((Writer)sw, "N3");
        this.log.debug((Object)sw.toString());
        try {
            lock = writeModel.getLock();
            lock.enterCriticalSection(false);
            if (writeModel instanceof OntModel) {
                ((OntModel)writeModel).getBaseModel().notifyEvent((Object)new EditEvent(editorUri, true));
            }
            writeModel.add(toBeAdded);
            writeModel.remove(toBeRetracted);
        }
        catch (Throwable t) {
            throw new Exception("Error while modifying model \n" + t.getMessage());
        }
        finally {
            if (writeModel instanceof OntModel) {
                ((OntModel)writeModel).getBaseModel().notifyEvent((Object)new EditEvent(editorUri, false));
            }
            lock.leaveCriticalSection();
        }
    }

    Set<Model> parseRdfParam(String[] parameters, String format) throws Exception {
        HashSet<Model> models = new HashSet<Model>();
        for (String param : parameters) {
            try {
                StringReader reader = new StringReader(param);
                Model model = ModelFactory.createDefaultModel();
                model.read((Reader)reader, null, format);
                models.add(model);
            }
            catch (Error ex) {
                this.log.error((Object)("Error reading RDF as " + format + " in " + param));
                throw new Exception("Error reading RDF, set log level to debug for this class to get error messages in the sever logs.");
            }
        }
        return models;
    }

    private Model getWriteModel(VitroRequest vreq) {
        return StandardModelSelector.selector.getModel((HttpServletRequest)vreq, this.getServletContext());
    }

    Model mergeModels(Set<Model> additions) {
        Model a = ModelFactory.createDefaultModel();
        for (Model m : additions) {
            a.add(m);
        }
        return a;
    }
}

