/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.edit;

import edu.cornell.mannlib.vedit.beans.EditProcessObject;
import edu.cornell.mannlib.vedit.beans.FormObject;
import edu.cornell.mannlib.vedit.beans.Option;
import edu.cornell.mannlib.vedit.controller.BaseEditController;
import edu.cornell.mannlib.vedit.util.FormUtils;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.beans.Property;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.DataPropertyDao;
import edu.cornell.mannlib.vitro.webapp.dao.ObjectPropertyDao;
import java.util.HashMap;
import java.util.List;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Properties2PropertiesRetryController
extends BaseEditController {
    private static final Log log = LogFactory.getLog((String)Properties2PropertiesRetryController.class.getName());

    @Override
    public void doGet(HttpServletRequest req, HttpServletResponse response) {
        if (!this.isAuthorizedToDisplayPage(req, response, SimplePermission.EDIT_ONTOLOGY.ACTION)) {
            return;
        }
        VitroRequest request = new VitroRequest(req);
        EditProcessObject epo = super.createEpo((HttpServletRequest)request);
        String action = null;
        if (epo.getAction() == null) {
            action = "insert";
            epo.setAction("insert");
        } else {
            action = epo.getAction();
        }
        ObjectPropertyDao opDao = request.getUnfilteredWebappDaoFactory().getObjectPropertyDao();
        DataPropertyDao dpDao = request.getUnfilteredWebappDaoFactory().getDataPropertyDao();
        epo.setDataAccessObject(opDao);
        List<Property> propList = "data".equals(request.getParameter("propertyType")) ? dpDao.getAllDataProperties() : opDao.getAllObjectProperties();
        this.sortForPickList(propList, request);
        String superpropertyURIstr = request.getParameter("SuperpropertyURI");
        String subpropertyURIstr = request.getParameter("SubpropertyURI");
        HashMap<String, Option> hashMap = new HashMap<String, Option>();
        List<Option> optionList = FormUtils.makeOptionListFromBeans(propList, "URI", "PickListName", superpropertyURIstr, null);
        List<Option> superPropertyOptions = this.getSortedList(hashMap, optionList, request);
        optionList = FormUtils.makeOptionListFromBeans(propList, "URI", "PickListName", subpropertyURIstr, null);
        List<Option> subPropertyOptions = this.getSortedList(hashMap, optionList, request);
        HashMap<String, List<Option>> hash = new HashMap<String, List<Option>>();
        hash.put("SuperpropertyURI", superPropertyOptions);
        hash.put("SubpropertyURI", subPropertyOptions);
        FormObject foo = new FormObject();
        foo.setOptionLists(hash);
        epo.setFormObject(foo);
        request.setAttribute("operation", "add");
        RequestDispatcher rd = request.getRequestDispatcher("/templates/page/basicPage.jsp");
        request.setAttribute("bodyJsp", "/templates/edit/formBasic.jsp");
        request.setAttribute("scripts", "/templates/edit/formBasic.js");
        String modeStr = request.getParameter("opMode");
        if (modeStr != null && (modeStr.equals("superproperty") || modeStr.equals("subproperty") || modeStr.equals("equivalentProperty"))) {
            request.setAttribute("editAction", "props2PropsOp");
            request.setAttribute("formJsp", "/templates/edit/specific/properties2properties_retry.jsp");
            request.setAttribute("title", modeStr.equals("superproperty") ? "Add Superproperty" : (modeStr.equals("equivalentProperty") ? "Add Equivalent Property" : "Add Subproperty"));
        }
        request.setAttribute("opMode", modeStr);
        request.setAttribute("_action", action);
        this.setRequestAttributes((HttpServletRequest)request, epo);
        try {
            rd.forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception e) {
            log.error((Object)(this.getClass().getName() + " could not forward to view."));
            log.error((Object)e.getMessage());
            log.error((Object)e.getStackTrace());
        }
    }
}

