/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.edit;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.shared.Lock;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.beans.DataProperty;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.ajax.VitroAjaxController;
import edu.cornell.mannlib.vitro.webapp.dao.DataPropertyStatementDao;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.dao.jena.event.EditEvent;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReorderController
extends VitroAjaxController {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ReorderController.class);
    private static String RANK_PREDICATE_PARAMETER_NAME = "predicate";
    private static String INDIVIDUAL_PREDICATE_PARAMETER_NAME = "individuals";

    @Override
    protected AuthorizationRequest requiredActions(VitroRequest vreq) {
        return SimplePermission.USE_BASIC_AJAX_CONTROLLERS.ACTION;
    }

    @Override
    protected void doRequest(VitroRequest vreq, HttpServletResponse response) {
        String errorMsg = null;
        String rankPredicate = vreq.getParameter(RANK_PREDICATE_PARAMETER_NAME);
        if (rankPredicate == null) {
            errorMsg = "No rank parameter specified";
            log.error((Object)errorMsg);
            this.doError(response, errorMsg, 400);
            return;
        }
        String[] individualUris = vreq.getParameterValues(INDIVIDUAL_PREDICATE_PARAMETER_NAME);
        if (individualUris == null || individualUris.length == 0) {
            errorMsg = "No individuals specified";
            log.error((Object)errorMsg);
            this.doError(response, errorMsg, 400);
            return;
        }
        WebappDaoFactory wadf = vreq.getWebappDaoFactory();
        if (vreq.getWebappDaoFactory() == null) {
            errorMsg = "No WebappDaoFactory available";
            log.error((Object)errorMsg);
            this.doError(response, errorMsg, 500);
            return;
        }
        DataPropertyStatementDao dpsDao = wadf.getDataPropertyStatementDao();
        if (dpsDao == null) {
            errorMsg = "No DataPropertyStatementDao available";
            log.error((Object)errorMsg);
            this.doError(response, errorMsg, 500);
            return;
        }
        boolean hasPermission = true;
        if (!hasPermission) {
            this.doError(response, "Insufficent permissions", 401);
            return;
        }
        this.reorderIndividuals(individualUris, vreq, rankPredicate);
        response.setStatus(200);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reorderIndividuals(String[] individualUris, VitroRequest vreq, String rankPredicate) {
        OntModel writeModel = vreq.getOntModelSelector().getABoxModel();
        Model additions = ModelFactory.createDefaultModel();
        Model retractions = ModelFactory.createDefaultModel();
        Property rankPredicateProperty = ResourceFactory.createProperty((String)rankPredicate);
        DataProperty dp = vreq.getWebappDaoFactory().getDataPropertyDao().getDataPropertyByURI(rankPredicate);
        String datapropURI = dp.getRangeDatatypeURI();
        int counter = 1;
        for (String individualUri : individualUris) {
            Resource individualResource = ResourceFactory.createResource((String)individualUri);
            retractions.add(writeModel.listStatements(individualResource, rankPredicateProperty, (RDFNode)null));
            log.debug((Object)("retractions = " + retractions));
            Literal dataLiteral = null;
            dataLiteral = datapropURI != null && datapropURI.length() > 0 ? ResourceFactory.createTypedLiteral((String)String.valueOf(counter), (RDFDatatype)TypeMapper.getInstance().getSafeTypeByName(datapropURI)) : ResourceFactory.createPlainLiteral((String)String.valueOf(counter));
            additions.add(individualResource, rankPredicateProperty, (RDFNode)dataLiteral);
            log.debug((Object)("additions = " + additions));
            ++counter;
        }
        Lock lock = null;
        try {
            lock = writeModel.getLock();
            lock.enterCriticalSection(false);
            writeModel.getBaseModel().notifyEvent((Object)new EditEvent(null, true));
            writeModel.remove(retractions);
            writeModel.add(additions);
        }
        catch (Throwable t) {
            log.error((Object)("error adding edit change n3required model to in memory model \n" + t.getMessage()));
        }
        finally {
            writeModel.getBaseModel().notifyEvent((Object)new EditEvent(null, false));
            lock.leaveCriticalSection();
        }
    }

    @Override
    protected void doError(HttpServletResponse response, String errorMsg, int httpstatus) {
        super.doError(response, "Error: " + errorMsg, httpstatus);
    }
}

