/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.edit;

import com.hp.hpl.jena.vocabulary.OWL;
import edu.cornell.mannlib.vedit.beans.EditProcessObject;
import edu.cornell.mannlib.vedit.beans.FormObject;
import edu.cornell.mannlib.vedit.beans.Option;
import edu.cornell.mannlib.vedit.controller.BaseEditController;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.beans.Ontology;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.beans.VClassGroup;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.VClassDao;
import edu.cornell.mannlib.vitro.webapp.dao.VClassGroupDao;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VclassEditController
extends BaseEditController {
    private static final Log log = LogFactory.getLog((String)VclassEditController.class.getName());
    private static final int NUM_COLS = 14;

    @Override
    public void doPost(HttpServletRequest req, HttpServletResponse response) {
        VClassGroupDao groupDao;
        VClassGroup classGroup;
        Ontology ont;
        if (!this.isAuthorizedToDisplayPage(req, response, SimplePermission.EDIT_ONTOLOGY.ACTION)) {
            return;
        }
        VitroRequest request = new VitroRequest(req);
        EditProcessObject epo = super.createEpo((HttpServletRequest)request, true);
        request.setAttribute("epoKey", epo.getKey());
        VClassDao vcwDao = ModelAccess.on(this.getServletContext()).getWebappDaoFactory(ModelAccess.ReasoningOption.ASSERTIONS_ONLY).getVClassDao();
        VClass vcl = vcwDao.getVClassByURI(request.getParameter("uri"));
        if (vcl == null) {
            vcl = request.getUnfilteredWebappDaoFactory().getVClassDao().getTopConcept();
        }
        request.setAttribute("VClass", vcl);
        ArrayList<String> results = new ArrayList<String>();
        results.add("class");
        results.add("class label");
        results.add("class group");
        results.add("ontology");
        results.add("RDF local name");
        results.add("short definition");
        results.add("example");
        results.add("editor description");
        results.add("display level");
        results.add("update level");
        results.add("display rank");
        results.add("custom entry form");
        results.add("URI");
        results.add("publish level");
        String ontologyName = null;
        if (vcl.getNamespace() != null && (ont = request.getUnfilteredWebappDaoFactory().getOntologyDao().getOntologyByURI(vcl.getNamespace())) != null && ont.getName() != null) {
            ontologyName = ont.getName();
        }
        WebappDaoFactory wadf = request.getUnfilteredWebappDaoFactory();
        String groupURI = vcl.getGroupURI();
        String groupName = "none";
        if (groupURI != null && (classGroup = (groupDao = wadf.getVClassGroupDao()).getGroupByURI(groupURI)) != null) {
            groupName = classGroup.getPublicName();
        }
        String shortDef = vcl.getShortDef() == null ? "" : vcl.getShortDef();
        String example = vcl.getExample() == null ? "" : vcl.getExample();
        String description = vcl.getDescription() == null ? "" : vcl.getDescription();
        boolean foundComment = false;
        StringBuffer commSb = null;
        Iterator<String> commIt = request.getUnfilteredWebappDaoFactory().getCommentsForResource(vcl.getURI()).iterator();
        while (commIt.hasNext()) {
            if (commSb == null) {
                commSb = new StringBuffer();
                foundComment = true;
            }
            commSb.append(commIt.next()).append(" ");
        }
        if (!foundComment) {
            commSb = new StringBuffer("no comments yet");
        }
        String hiddenFromDisplay = vcl.getHiddenFromDisplayBelowRoleLevel() == null ? "(unspecified)" : vcl.getHiddenFromDisplayBelowRoleLevel().getDisplayLabel();
        String ProhibitedFromUpdate = vcl.getProhibitedFromUpdateBelowRoleLevel() == null ? "(unspecified)" : vcl.getProhibitedFromUpdateBelowRoleLevel().getUpdateLabel();
        String hiddenFromPublish = vcl.getHiddenFromPublishBelowRoleLevel() == null ? "(unspecified)" : vcl.getHiddenFromPublishBelowRoleLevel().getDisplayLabel();
        String customEntryForm = vcl.getCustomEntryForm() == null ? "(unspecified)" : vcl.getCustomEntryForm();
        String uri = vcl.getURI() == null ? "" : vcl.getURI();
        results.add(vcl.getPickListName());
        results.add(vcl.getName() == null ? "(no public label)" : vcl.getName());
        results.add(groupName);
        results.add(ontologyName == null ? "(not identified)" : ontologyName);
        results.add(vcl.getLocalName());
        results.add(shortDef);
        results.add(example);
        results.add(description);
        results.add(hiddenFromDisplay);
        results.add(ProhibitedFromUpdate);
        results.add(String.valueOf(vcl.getDisplayRank()));
        results.add(customEntryForm);
        results.add(uri);
        results.add(hiddenFromPublish);
        request.setAttribute("results", results);
        request.setAttribute("columncount", 14);
        request.setAttribute("suppressquery", "true");
        epo.setDataAccessObject(vcl);
        FormObject foo = new FormObject();
        HashMap<String, List<Option>> OptionMap = new HashMap<String, List<Option>>();
        HashMap formSelect = new HashMap();
        request.setAttribute("formSelect", formSelect);
        VClassDao vcDao = ModelAccess.on(this.getServletContext()).getWebappDaoFactory(ModelAccess.ReasoningOption.ASSERTIONS_ONLY).getVClassDao();
        VClassDao displayVcDao = ModelAccess.on(this.getServletContext()).getWebappDaoFactory().getVClassDao();
        List<VClass> superVClasses = this.getVClassesForURIList(vcDao.getSuperClassURIs(vcl.getURI(), false), displayVcDao);
        this.sortForPickList(superVClasses, request);
        request.setAttribute("superclasses", superVClasses);
        List<VClass> subVClasses = this.getVClassesForURIList(vcDao.getSubClassURIs(vcl.getURI()), displayVcDao);
        this.sortForPickList(subVClasses, request);
        request.setAttribute("subclasses", subVClasses);
        List<VClass> djVClasses = this.getVClassesForURIList(vcDao.getDisjointWithClassURIs(vcl.getURI()), displayVcDao);
        this.sortForPickList(djVClasses, request);
        request.setAttribute("disjointClasses", djVClasses);
        List<VClass> eqVClasses = this.getVClassesForURIList(vcDao.getEquivalentClassURIs(vcl.getURI()), displayVcDao);
        this.sortForPickList(eqVClasses, request);
        request.setAttribute("equivalentClasses", eqVClasses);
        foo.setOptionLists(OptionMap);
        epo.setFormObject(foo);
        boolean instantiable = !vcl.getURI().equals(OWL.Nothing.getURI());
        RequestDispatcher rd = request.getRequestDispatcher("/templates/page/basicPage.jsp");
        request.setAttribute("epoKey", epo.getKey());
        request.setAttribute("vclassWebapp", vcl);
        request.setAttribute("instantiable", instantiable);
        request.setAttribute("bodyJsp", "/templates/edit/specific/classes_edit.jsp");
        request.setAttribute("title", "Class Control Panel");
        try {
            rd.forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception e) {
            log.error((Object)"VclassEditController could not forward to view.");
            log.error((Object)e.getMessage());
            log.error((Object)e.getStackTrace());
        }
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        this.doPost(request, response);
    }

    private List<VClass> getVClassesForURIList(List<String> vclassURIs, VClassDao vcDao) {
        ArrayList<VClass> vclasses = new ArrayList<VClass>();
        for (String vclassURI : vclassURIs) {
            VClass vclass = vcDao.getVClassByURI(vclassURI);
            if (vclass == null) continue;
            vclasses.add(vclass);
        }
        return vclasses;
    }
}

