/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.edit.listing;

import edu.cornell.mannlib.vedit.controller.BaseEditController;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.beans.VClassGroup;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.VClassGroupDao;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public class AllClassGroupsListingController
extends BaseEditController {
    private static final long serialVersionUID = 1L;

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        if (!this.isAuthorizedToDisplayPage(request, response, SimplePermission.EDIT_ONTOLOGY.ACTION)) {
            return;
        }
        VitroRequest vreq = new VitroRequest(request);
        VClassGroupDao dao = vreq.getUnfilteredWebappDaoFactory().getVClassGroupDao();
        List<VClassGroup> groups = dao.getPublicGroupsWithVClasses();
        ArrayList<String> results = new ArrayList<String>();
        results.add("XX");
        results.add("Group");
        results.add("display rank");
        results.add("");
        results.add("XX");
        if (groups != null) {
            for (VClassGroup vcg : groups) {
                results.add("XX");
                String publicName = vcg.getPublicName();
                if (StringUtils.isBlank((String)publicName)) {
                    publicName = "(unnamed group)";
                }
                try {
                    results.add("<a href=\"./editForm?uri=" + URLEncoder.encode(vcg.getURI(), "UTF-8") + "&amp;controller=Classgroup\">" + publicName + "</a>");
                }
                catch (Exception e) {
                    results.add(publicName);
                }
                Integer t = vcg.getDisplayRank();
                results.add(t != -1 ? t.toString() : "");
                results.add("");
                results.add("XX");
                List<VClass> classList = vcg.getVitroClassList();
                if (classList == null || classList.size() <= 0) continue;
                results.add("+");
                results.add("XX");
                results.add("Class");
                results.add("example");
                results.add("description");
                results.add("@@entities");
                Iterator<VClass> classIt = classList.iterator();
                while (classIt.hasNext()) {
                    VClass vcw = classIt.next();
                    results.add("XX");
                    if (vcw.getName() != null && vcw.getURI() != null) {
                        try {
                            results.add("<a href=\"vclassEdit?uri=" + URLEncoder.encode(vcw.getURI(), "UTF-8") + "\">" + vcw.getName() + "</a>");
                        }
                        catch (Exception e) {
                            results.add(vcw.getName());
                        }
                    } else {
                        results.add("");
                    }
                    String exampleStr = vcw.getExample() == null ? "" : vcw.getName();
                    results.add(exampleStr);
                    String descriptionStr = vcw.getDescription() == null ? "" : vcw.getDescription();
                    results.add(descriptionStr);
                    if (!classIt.hasNext()) continue;
                    results.add("@@entities");
                }
            }
            request.setAttribute("results", results);
        }
        request.setAttribute("columncount", (Object)new Integer(5));
        request.setAttribute("suppressquery", (Object)"true");
        request.setAttribute("title", (Object)"Class Groups");
        request.setAttribute("bodyJsp", (Object)"/templates/edit/fetch/horizontal.jsp");
        request.setAttribute("horizontalJspAddButtonUrl", (Object)"editForm");
        request.setAttribute("horizontalJspAddButtonText", (Object)"Add new class group");
        request.setAttribute("horizontalJspAddButtonControllerParam", (Object)"Classgroup");
        RequestDispatcher rd = request.getRequestDispatcher("/templates/page/basicPage.jsp");
        try {
            rd.forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

