/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.edit.listing;

import edu.cornell.mannlib.vedit.controller.BaseEditController;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.beans.DataProperty;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.beans.Property;
import edu.cornell.mannlib.vitro.webapp.beans.PropertyGroup;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.PropertyGroupDao;
import java.net.URLEncoder;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertyGroupsListingController
extends BaseEditController {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(PropertyGroupsListingController.class);
    private static final boolean WITH_PROPERTIES = true;

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        if (!this.isAuthorizedToDisplayPage(request, response, SimplePermission.EDIT_ONTOLOGY.ACTION)) {
            return;
        }
        VitroRequest vreq = new VitroRequest(request);
        PropertyGroupDao dao = vreq.getUnfilteredWebappDaoFactory().getPropertyGroupDao();
        List<PropertyGroup> groups = dao.getPublicGroups(true);
        PropertySorter comparator = new PropertySorter(vreq.getCollator());
        ArrayList<String> results = new ArrayList<String>();
        results.add("XX");
        results.add("group");
        results.add("display rank");
        results.add("");
        results.add("XX");
        if (groups != null) {
            for (PropertyGroup pg : groups) {
                results.add("XX");
                String publicName = pg.getName();
                if (StringUtils.isBlank((String)publicName)) {
                    publicName = "(unnamed group)";
                }
                try {
                    results.add("<a href=\"./editForm?uri=" + URLEncoder.encode(pg.getURI(), "UTF-8") + "&amp;controller=PropertyGroup\">" + publicName + "</a>");
                }
                catch (Exception e) {
                    results.add(publicName);
                }
                Integer t = pg.getDisplayRank();
                results.add(t != -1 ? t.toString() : "");
                results.add("");
                results.add("XX");
                List<Property> propertyList = pg.getPropertyList();
                if (propertyList == null || propertyList.size() <= 0) continue;
                Collections.sort(propertyList, comparator);
                results.add("+");
                results.add("XX");
                results.add("property");
                results.add("");
                results.add("");
                results.add("@@entities");
                Iterator<Property> propIt = propertyList.iterator();
                while (propIt.hasNext()) {
                    String nameStr;
                    Property prop = propIt.next();
                    results.add("XX");
                    String controllerStr = "propertyEdit";
                    String string = nameStr = prop.getLabel() == null ? "" : prop.getLabel();
                    if (prop instanceof ObjectProperty) {
                        nameStr = ((ObjectProperty)prop).getDomainPublic();
                    } else if (prop instanceof DataProperty) {
                        controllerStr = "datapropEdit";
                        nameStr = ((DataProperty)prop).getName();
                    }
                    if (prop.getURI() != null) {
                        try {
                            results.add("<a href=\"" + controllerStr + "?uri=" + URLEncoder.encode(prop.getURI(), "UTF-8") + "\">" + nameStr + "</a>");
                        }
                        catch (Exception e) {
                            results.add(nameStr);
                        }
                    } else {
                        results.add(nameStr);
                    }
                    String exampleStr = "";
                    results.add(exampleStr);
                    String descriptionStr = "";
                    results.add(descriptionStr);
                    if (!propIt.hasNext()) continue;
                    results.add("@@entities");
                }
            }
            request.setAttribute("results", results);
        }
        request.setAttribute("columncount", (Object)new Integer(5));
        request.setAttribute("suppressquery", (Object)"true");
        request.setAttribute("title", (Object)"Property Groups");
        request.setAttribute("bodyJsp", (Object)"/templates/edit/fetch/horizontal.jsp");
        request.setAttribute("horizontalJspAddButtonUrl", (Object)"editForm");
        request.setAttribute("horizontalJspAddButtonText", (Object)"Add new property group");
        request.setAttribute("horizontalJspAddButtonControllerParam", (Object)"PropertyGroup");
        RequestDispatcher rd = request.getRequestDispatcher("/templates/page/basicPage.jsp");
        try {
            rd.forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private class PropertySorter
    implements Comparator<Property> {
        Collator collator;

        public PropertySorter(Collator collator) {
            this.collator = collator;
        }

        @Override
        public int compare(Property p1, Property p2) {
            String name1 = this.getName(p1);
            String name2 = this.getName(p2);
            if (name1 == null && name2 != null) {
                return 1;
            }
            if (name2 == null && name1 != null) {
                return -1;
            }
            if (name1 == null && name2 == null) {
                return 0;
            }
            return this.collator.compare(name1, name2);
        }

        private String getName(Property prop) {
            if (prop instanceof ObjectProperty) {
                return ((ObjectProperty)prop).getDomainPublic();
            }
            if (prop instanceof DataProperty) {
                return ((DataProperty)prop).getName();
            }
            return prop.getLabel();
        }
    }
}

